/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.BatchingPhysicalTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogHeaderVisitor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogRotation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionAppender;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionCursor;
import org.neo4j.kernel.impl.transaction.log.ReadableVersionableLogChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReaderFactory;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class PhysicalLogicalTransactionStore
extends LifecycleAdapter
implements LogicalTransactionStore {
    private final LogFile logFile;
    private final LogRotation logRotation;
    private final TransactionMetadataCache transactionMetadataCache;
    private TransactionAppender appender;
    private final TransactionIdStore transactionIdStore;
    private final boolean batchedWrites;
    private final IdOrderingQueue legacyIndexTransactionOrdering;
    private final KernelHealth kernelHealth;
    private static final TransactionMetadataCache.TransactionMetadata METADATA_FOR_EMPTY_STORE = new TransactionMetadataCache.TransactionMetadata(-1, -1, new LogPosition(0L, 16L), 0L);

    public PhysicalLogicalTransactionStore(LogFile logFile, LogRotation logRotation, TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore, IdOrderingQueue legacyIndexTransactionOrdering, KernelHealth kernelHealth, boolean batchedWrites) {
        this.logFile = logFile;
        this.logRotation = logRotation;
        this.transactionMetadataCache = transactionMetadataCache;
        this.transactionIdStore = transactionIdStore;
        this.legacyIndexTransactionOrdering = legacyIndexTransactionOrdering;
        this.kernelHealth = kernelHealth;
        this.batchedWrites = batchedWrites;
    }

    @Override
    public void start() throws Throwable {
        this.appender = this.batchedWrites ? new BatchingPhysicalTransactionAppender(this.logFile, this.logRotation, this.transactionMetadataCache, this.transactionIdStore, this.legacyIndexTransactionOrdering, this.kernelHealth) : new PhysicalTransactionAppender(this.logFile, this.logRotation, this.transactionMetadataCache, this.transactionIdStore, this.legacyIndexTransactionOrdering, this.kernelHealth);
    }

    @Override
    public void shutdown() throws Throwable {
        this.appender.close();
    }

    @Override
    public TransactionAppender getAppender() {
        return this.appender;
    }

    @Override
    public IOCursor<CommittedTransactionRepresentation> getTransactions(long transactionIdToStartFrom) throws IOException {
        try {
            TransactionMetadataCache.TransactionMetadata transactionMetadata = this.transactionMetadataCache.getTransactionMetadata(transactionIdToStartFrom);
            LogEntryReader<ReadableVersionableLogChannel> logEntryReader = new LogEntryReaderFactory().versionable();
            if (transactionMetadata != null) {
                ReadableVersionableLogChannel channel = this.logFile.getReader(transactionMetadata.getStartPosition());
                return new PhysicalTransactionCursor<ReadableVersionableLogChannel>(channel, logEntryReader);
            }
            LogVersionLocator headerVisitor = new LogVersionLocator(transactionIdToStartFrom);
            this.logFile.accept(headerVisitor);
            TransactionPositionLocator transactionPositionLocator = new TransactionPositionLocator(transactionIdToStartFrom, logEntryReader);
            this.logFile.accept(transactionPositionLocator, headerVisitor.getLogPosition());
            LogPosition position = transactionPositionLocator.getAndCacheFoundLogPosition(this.transactionMetadataCache);
            return new PhysicalTransactionCursor<ReadableVersionableLogChannel>(this.logFile.getReader(position), logEntryReader);
        }
        catch (FileNotFoundException e) {
            throw new NoSuchTransactionException(transactionIdToStartFrom, "Log position acquired, but couldn't find the log file itself. Perhaps it just recently was deleted?");
        }
    }

    @Override
    public TransactionMetadataCache.TransactionMetadata getMetadataFor(long transactionId) throws IOException {
        if (transactionId <= 1L) {
            return METADATA_FOR_EMPTY_STORE;
        }
        TransactionMetadataCache.TransactionMetadata transactionMetadata = this.transactionMetadataCache.getTransactionMetadata(transactionId);
        if (transactionMetadata == null) {
            try (IOCursor<CommittedTransactionRepresentation> cursor = this.getTransactions(transactionId);){
                while (cursor.next()) {
                    CommittedTransactionRepresentation tx = cursor.get();
                    long committedTxId = tx.getCommitEntry().getTxId();
                    TransactionMetadataCache.TransactionMetadata metadata = this.transactionMetadataCache.cacheTransactionMetadata(committedTxId, tx.getStartEntry().getStartPosition(), tx.getStartEntry().getMasterId(), tx.getStartEntry().getLocalId(), LogEntryStart.checksum(tx.getStartEntry()));
                    if (committedTxId != transactionId) continue;
                    transactionMetadata = metadata;
                }
            }
            if (transactionMetadata == null) {
                throw new NoSuchTransactionException(transactionId);
            }
        }
        return transactionMetadata;
    }

    public static final class LogVersionLocator
    implements LogHeaderVisitor {
        private final long transactionId;
        private LogPosition foundPosition;

        public LogVersionLocator(long transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public boolean visit(LogPosition position, long firstTransactionIdInLog, long lastTransactionIdInLog) {
            boolean foundIt;
            boolean bl = foundIt = this.transactionId >= firstTransactionIdInLog && this.transactionId <= lastTransactionIdInLog;
            if (foundIt) {
                this.foundPosition = position;
            }
            return !foundIt;
        }

        public LogPosition getLogPosition() throws NoSuchTransactionException {
            if (this.foundPosition == null) {
                throw new NoSuchTransactionException(this.transactionId, "Couldn't find any log containing " + this.transactionId);
            }
            return this.foundPosition;
        }
    }

    public static class TransactionPositionLocator
    implements LogFile.LogFileVisitor {
        private final long startTransactionId;
        private final LogEntryReader<ReadableVersionableLogChannel> logEntryReader;
        private LogEntryStart startEntryForFoundTransaction;

        public TransactionPositionLocator(long startTransactionId, LogEntryReader<ReadableVersionableLogChannel> logEntryReader) {
            this.startTransactionId = startTransactionId;
            this.logEntryReader = logEntryReader;
        }

        @Override
        public boolean visit(LogPosition position, ReadableVersionableLogChannel channel) throws IOException {
            LogEntry logEntry;
            LogEntryStart startEntry = null;
            while ((logEntry = this.logEntryReader.readLogEntry(channel)) != null) {
                switch (logEntry.getType()) {
                    case 1: {
                        startEntry = (LogEntryStart)logEntry.as();
                        break;
                    }
                    case 5: {
                        LogEntryCommit commit = (LogEntryCommit)logEntry.as();
                        if (commit.getTxId() != this.startTransactionId) break;
                        this.startEntryForFoundTransaction = startEntry;
                        return false;
                    }
                }
            }
            return true;
        }

        public LogPosition getAndCacheFoundLogPosition(TransactionMetadataCache transactionMetadataCache) throws NoSuchTransactionException {
            if (this.startEntryForFoundTransaction == null) {
                throw new NoSuchTransactionException(this.startTransactionId);
            }
            transactionMetadataCache.cacheTransactionMetadata(this.startTransactionId, this.startEntryForFoundTransaction.getStartPosition(), this.startEntryForFoundTransaction.getMasterId(), this.startEntryForFoundTransaction.getLocalId(), LogEntryStart.checksum(this.startEntryForFoundTransaction));
            return this.startEntryForFoundTransaction.getStartPosition();
        }
    }
}

