/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.standard;

import java.io.IOException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.format.Store;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreToolkit;

public class BaseRecordCursor<RECORD, FORMAT extends StoreFormat.RecordFormat<RECORD>>
implements Store.RecordCursor<RECORD> {
    private final PagedFile file;
    private final byte stepSize;
    protected final StoreToolkit toolkit;
    protected final FORMAT format;
    private final int pageCacheFlags;
    protected PageCursor pageCursor;
    protected long currentRecordId = -1L;
    protected int currentRecordOffset = -1;
    protected RECORD record;

    public BaseRecordCursor(PagedFile file, StoreToolkit toolkit, FORMAT format, int flags) {
        this.file = file;
        this.toolkit = toolkit;
        this.format = format;
        this.pageCacheFlags = this.pageCursorFlags(flags);
        if ((flags & 2) == 0) {
            this.currentRecordId = toolkit.firstRecordId() - 1L;
            this.stepSize = 1;
        } else {
            this.currentRecordId = toolkit.highestKnownId() + 1L;
            this.stepSize = (byte)-1;
        }
        this.record = format.newRecord(-1L);
    }

    @Override
    public RECORD reusedRecord() {
        this.format.deserialize(this.pageCursor, this.currentRecordOffset, this.currentRecordId, this.record);
        return this.record;
    }

    @Override
    public RECORD clonedRecord() {
        Object result = this.format.newRecord(this.currentRecordId);
        this.format.deserialize(this.pageCursor, this.currentRecordOffset, this.currentRecordId, result);
        return result;
    }

    @Override
    public long recordId() {
        return this.currentRecordId;
    }

    @Override
    public boolean inUse() {
        return this.format.inUse(this.pageCursor, this.currentRecordOffset);
    }

    @Override
    public boolean position(long id) {
        try {
            if (id < 0L) {
                return false;
            }
            long pageId = this.toolkit.pageId(id);
            this.currentRecordId = id;
            this.currentRecordOffset = this.toolkit.recordOffset(id);
            if (this.pageCursor == null) {
                this.pageCursor = this.file.io(pageId, this.pageCacheFlags);
                return this.pageCursor.next(pageId);
            }
            return pageId == this.pageCursor.getCurrentPageId() || this.pageCursor.next(pageId);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Failed to read record " + id + ".", e);
        }
    }

    @Override
    public boolean next() {
        while (this.position(this.currentRecordId + (long)this.stepSize)) {
            if (!this.inUse()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRetry() throws IOException {
        return this.pageCursor.shouldRetry();
    }

    @Override
    public void close() {
        if (this.pageCursor != null) {
            this.pageCursor.close();
        }
    }

    private int pageCursorFlags(int storeCursorFlags) {
        int flags = 1;
        if ((storeCursorFlags & 1) != 0) {
            flags |= 0x20;
            if ((storeCursorFlags & 2) == 0) {
                flags |= 8;
            }
        }
        return flags;
    }
}

