/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.RunnablePageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class LifecycledPageCache
extends LifecycleAdapter
implements PageCache {
    private final PageSwapperFactory swapperFactory;
    private final JobScheduler scheduler;
    private final Config config;
    private final PageCacheTracer tracer;
    private RunnablePageCache pageCache;
    private boolean stopped;
    private JobScheduler.JobHandle pageEvictionJobHandle;

    public LifecycledPageCache(PageSwapperFactory swapperFactory, JobScheduler scheduler, Config config, PageCacheTracer tracer) {
        this.swapperFactory = swapperFactory;
        this.scheduler = scheduler;
        this.config = config;
        this.tracer = tracer;
        this.initialisePageCache();
    }

    protected void initialisePageCache() {
        this.pageCache = new MuninnPageCache(this.swapperFactory, LifecycledPageCache.calculateMaxPages(this.config), LifecycledPageCache.calculatePageSize(this.config), this.tracer);
    }

    private static int calculateMaxPages(Config config) {
        long availableMemory = config.get(GraphDatabaseSettings.pagecache_memory);
        long pageSize = config.get(GraphDatabaseSettings.mapped_memory_page_size);
        long pageCount = availableMemory / pageSize;
        return (int)Math.min(Integer.MAX_VALUE, pageCount);
    }

    private static int calculatePageSize(Config config) {
        return config.get(GraphDatabaseSettings.mapped_memory_page_size).intValue();
    }

    @Override
    public synchronized void start() {
        if (this.stopped) {
            this.initialisePageCache();
            this.stopped = false;
        }
        this.pageEvictionJobHandle = this.scheduler.schedule(JobScheduler.Group.pageCacheEviction, (Runnable)this.pageCache);
    }

    @Override
    public synchronized void stop() throws IOException {
        JobScheduler.JobHandle handle = this.pageEvictionJobHandle;
        if (handle != null) {
            handle.cancel(true);
        }
        this.pageCache.close();
        this.stopped = true;
    }

    public void close() throws IOException {
        throw new UnsupportedOperationException("This page cache is life-cycled and cannot be directly closed.");
    }

    public PagedFile map(File file, int filePageSize) throws IOException {
        return this.pageCache.map(file, filePageSize);
    }

    public void flush() throws IOException {
        this.pageCache.flush();
    }

    public int pageSize() {
        return this.pageCache.pageSize();
    }

    public int maxCachedPages() {
        return this.pageCache.maxCachedPages();
    }

    public void dumpConfiguration(StringLogger messagesLog) {
        long totalPhysicalMemory = LifecycledPageCache.totalPhysicalMemory();
        String totalPhysicalMemMb = totalPhysicalMemory == -1L ? "?" : "" + totalPhysicalMemory / 1024L / 1024L;
        long maxVmUsageMb = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        long pageCacheMb = this.maxCachedPages() * this.pageSize() / 1024 / 1024;
        String msg = "Physical mem: " + totalPhysicalMemMb + " MiB," + " Heap size: " + maxVmUsageMb + " MiB," + " Page cache size: " + pageCacheMb + " MiB.";
        messagesLog.info(msg);
    }

    public static long totalPhysicalMemory() {
        try {
            Class<?> beanClass = Thread.currentThread().getContextClassLoader().loadClass("com.sun.management.OperatingSystemMXBean");
            Method method = beanClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
            return (Long)method.invoke((Object)ManagementFactory.getOperatingSystemMXBean(), new Object[0]);
        }
        catch (Exception | LinkageError e) {
            return -1L;
        }
    }

    public PageCache unwrap() {
        return this.pageCache;
    }
}

