/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.function.primitive.FunctionFromPrimitiveLong;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.QueryExecutionException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.event.KernelEventHandler;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.IndexProviders;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.ResourceClosingIterator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.kernel.AvailabilityGuard;
import org.neo4j.kernel.DatabaseAvailability;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.DefaultIdGeneratorFactory;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.KernelData;
import org.neo4j.kernel.KernelDiagnostics;
import org.neo4j.kernel.KernelEventHandlers;
import org.neo4j.kernel.KernelHealth;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.PlaceboTransaction;
import org.neo4j.kernel.StoreLocker;
import org.neo4j.kernel.StoreLockerLifecycleAdapter;
import org.neo4j.kernel.TopLevelTransaction;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.Version;
import org.neo4j.kernel.api.KernelAPI;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.extension.UnsatisfiedDependencyStrategies;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.impl.api.CommitProcessFactory;
import org.neo4j.kernel.impl.api.NonTransactionalTokenNameLookup;
import org.neo4j.kernel.impl.api.ReadOnlyTransactionCommitProcess;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationCommitProcess;
import org.neo4j.kernel.impl.api.TransactionRepresentationStoreApplier;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.RemoveOrphanConstraintIndexesOnStartup;
import org.neo4j.kernel.impl.cache.BridgingCacheAccess;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.cache.MonitorGc;
import org.neo4j.kernel.impl.cache.NoCacheProvider;
import org.neo4j.kernel.impl.core.CacheAccessBackDoor;
import org.neo4j.kernel.impl.core.Caches;
import org.neo4j.kernel.impl.core.DefaultCaches;
import org.neo4j.kernel.impl.core.DefaultLabelIdCreator;
import org.neo4j.kernel.impl.core.DefaultPropertyTokenCreator;
import org.neo4j.kernel.impl.core.DefaultRelationshipTypeCreator;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.core.NodeProxy;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.ReadOnlyTokenCreator;
import org.neo4j.kernel.impl.core.RelationshipProxy;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.StartupStatistics;
import org.neo4j.kernel.impl.core.StartupStatisticsProvider;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.core.TokenCreator;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.coreapi.IndexManagerImpl;
import org.neo4j.kernel.impl.coreapi.IndexProviderImpl;
import org.neo4j.kernel.impl.coreapi.LegacyIndexProxy;
import org.neo4j.kernel.impl.coreapi.NodeAutoIndexerImpl;
import org.neo4j.kernel.impl.coreapi.RelationshipAutoIndexerImpl;
import org.neo4j.kernel.impl.coreapi.schema.SchemaImpl;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.locking.community.CommunityLockManger;
import org.neo4j.kernel.impl.pagecache.LifecycledPageCache;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.impl.query.QueryExecutionEngine;
import org.neo4j.kernel.impl.query.QueryExecutionKernelException;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.storemigration.ConfigMapUpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.StoreMigrator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.UpgradeConfiguration;
import org.neo4j.kernel.impl.storemigration.monitoring.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.impl.transaction.RecoveryVerifier;
import org.neo4j.kernel.impl.transaction.TransactionCounters;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFile;
import org.neo4j.kernel.impl.transaction.state.DataSourceManager;
import org.neo4j.kernel.impl.transaction.state.NeoStoreInjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;
import org.neo4j.kernel.impl.traversal.BidirectionalTraversalDescriptionImpl;
import org.neo4j.kernel.impl.traversal.MonoDirectionalTraversalDescription;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.info.DiagnosticsManager;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.kernel.info.JvmMetadataRepository;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleException;
import org.neo4j.kernel.lifecycle.LifecycleListener;
import org.neo4j.kernel.lifecycle.LifecycleStatus;
import org.neo4j.kernel.logging.DefaultLogging;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.RollingLogMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.kernel.monitoring.tracing.Tracers;
import org.neo4j.tooling.GlobalGraphOperations;

@Deprecated
public abstract class InternalAbstractGraphDatabase
implements GraphDatabaseService,
GraphDatabaseAPI,
SchemaWriteGuard {
    private static final long MAX_NODE_ID = IdType.NODE.getMaxValue();
    private static final long MAX_RELATIONSHIP_ID = IdType.RELATIONSHIP.getMaxValue();
    public static CommitProcessFactory defaultCommitProcessFactory = new CommitProcessFactory(){

        @Override
        public TransactionCommitProcess create(LogicalTransactionStore logicalTransactionStore, KernelHealth kernelHealth, NeoStore neoStore, TransactionRepresentationStoreApplier storeApplier, NeoStoreInjectedTransactionValidator validator, TransactionApplicationMode mode, Config config) {
            if (config.get(GraphDatabaseSettings.read_only).booleanValue()) {
                return new ReadOnlyTransactionCommitProcess();
            }
            return new TransactionRepresentationCommitProcess(logicalTransactionStore, kernelHealth, neoStore, storeApplier, mode);
        }
    };
    protected final DependencyResolver dependencyResolver;
    protected final Config config;
    protected final LifeSupport life = new LifeSupport();
    private final Dependencies dependencies;
    private final Map<String, CacheProvider> cacheProviders;
    protected KernelExtensions kernelExtensions;
    protected File storeDir;
    protected Logging logging;
    protected StoreId storeId;
    protected StringLogger msgLog;
    protected StoreLockerLifecycleAdapter storeLocker;
    protected KernelEventHandlers kernelEventHandlers;
    protected TransactionEventHandlers transactionEventHandlers;
    protected RelationshipTypeTokenHolder relationshipTypeTokenHolder;
    protected PropertyKeyTokenHolder propertyKeyTokenHolder;
    protected LabelTokenHolder labelTokenHolder;
    protected NodeManager nodeManager;
    protected IndexManager indexManager;
    protected Schema schema;
    protected KernelPanicEventGenerator kernelPanicEventGenerator;
    protected KernelHealth kernelHealth;
    protected FileSystemAbstraction fileSystem;
    protected Locks lockManager;
    protected IdGeneratorFactory idGeneratorFactory;
    protected IndexConfigStore indexStore;
    protected LifecycledPageCache pageCache;
    protected StoreFactory storeFactory;
    protected DiagnosticsManager diagnosticsManager;
    protected NeoStoreDataSource neoDataSource;
    protected RecoveryVerifier recoveryVerifier;
    protected Guard guard;
    protected NodeAutoIndexerImpl nodeAutoIndexer;
    protected RelationshipAutoIndexerImpl relAutoIndexer;
    protected KernelData extensions;
    protected Caches caches;
    protected ThreadToStatementContextBridge threadToTransactionBridge;
    protected BridgingCacheAccess cacheBridge;
    protected JobScheduler jobScheduler;
    protected Monitors monitors;
    protected TransactionCounters transactionMonitor;
    protected Tracers tracers;
    protected AvailabilityGuard availabilityGuard;
    protected long transactionStartTimeout;
    protected StoreUpgrader storeMigrationProcess;
    protected DataSourceManager dataSourceManager;
    private StartupStatisticsProvider startupStatistics;
    private QueryExecutionEngine queryExecutor = QueryEngineProvider.noEngine();

    protected InternalAbstractGraphDatabase(String storeDir, Map<String, String> params, Dependencies dependencies) {
        params.put(Configuration.store_dir.name(), storeDir);
        this.dependencyResolver = new DependencyResolverImpl();
        this.dependencies = dependencies;
        this.cacheProviders = this.mapCacheProviders(this.dependencies.cacheProviders());
        this.config = new Config(params, this.getSettingsClasses(dependencies.settingsClasses(), dependencies.kernelExtensions(), dependencies.cacheProviders()));
        this.logging = dependencies.logging();
        this.monitors = dependencies.monitors();
        this.storeDir = this.config.get(Configuration.store_dir);
        this.transactionStartTimeout = this.config.get(GraphDatabaseSettings.transaction_start_timeout);
    }

    private Map<String, CacheProvider> mapCacheProviders(Iterable<CacheProvider> cacheProviders) {
        HashMap<String, CacheProvider> map = new HashMap<String, CacheProvider>();
        for (CacheProvider provider : cacheProviders) {
            map.put(provider.getName(), provider);
        }
        return map;
    }

    protected void run() {
        this.create();
        boolean failed = false;
        try {
            this.enableAvailabilityLogging();
            this.registerRecovery();
            this.life.start();
        }
        catch (Throwable throwable) {
            failed = true;
            throw new RuntimeException("Error starting " + this.getClass().getName() + ", " + this.storeDir.getAbsolutePath(), throwable);
        }
        finally {
            if (failed) {
                this.shutdown();
            }
        }
    }

    protected TransactionCounters createTransactionCounters() {
        return new TransactionCounters();
    }

    private Tracers createTracers(Config config, StringLogger msgLog) {
        String desiredImplementationName = config.get(Configuration.tracer);
        return new Tracers(desiredImplementationName, msgLog);
    }

    protected void createDatabaseAvailability() {
        this.life.add(new DatabaseAvailability(this.availabilityGuard, this.transactionMonitor));
    }

    private void enableAvailabilityLogging() {
        this.availabilityGuard.addListener(new AvailabilityGuard.AvailabilityListener(){

            @Override
            public void available() {
                InternalAbstractGraphDatabase.this.msgLog.info("Database is now ready");
            }

            @Override
            public void unavailable() {
                InternalAbstractGraphDatabase.this.msgLog.info("Database is now unavailable");
            }
        });
    }

    protected void registerRecovery() {
        this.life.addLifecycleListener(new LifecycleListener(){

            @Override
            public void notifyStatusChanged(Object instance, LifecycleStatus from, LifecycleStatus to) {
                if (instance instanceof KernelExtensions && to.equals((Object)LifecycleStatus.STARTED)) {
                    InternalAbstractGraphDatabase.this.doAfterRecoveryAndStartup(true);
                }
            }
        });
    }

    protected void doAfterRecoveryAndStartup(boolean isMaster) {
        this.storeId = this.neoDataSource.getStoreId();
        KernelDiagnostics.register(this.diagnosticsManager, this, this.neoDataSource);
        if (isMaster) {
            new RemoveOrphanConstraintIndexesOnStartup(this.neoDataSource.getKernel(), this.logging).perform();
        }
    }

    protected void create() {
        this.kernelExtensions = new KernelExtensions(this.dependencies.kernelExtensions(), this.config, this.getDependencyResolver(), UnsatisfiedDependencyStrategies.fail());
        this.availabilityGuard = new AvailabilityGuard(Clock.SYSTEM_CLOCK);
        this.fileSystem = this.createFileSystemAbstraction();
        if (this.logging == null) {
            this.logging = this.createLogging();
        }
        if (this.monitors == null) {
            this.monitors = this.createMonitors();
        }
        this.transactionMonitor = this.createTransactionCounters();
        this.storeMigrationProcess = new StoreUpgrader(this.createUpgradeConfiguration(), this.fileSystem, this.monitors.newMonitor(StoreUpgrader.Monitor.class, new String[0]), this.logging);
        this.msgLog = this.logging.getMessagesLog(this.getClass());
        this.config.setLogger(this.msgLog);
        this.tracers = this.createTracers(this.config, this.msgLog);
        this.storeLocker = this.life.add(new StoreLockerLifecycleAdapter(new StoreLocker(this.fileSystem), this.storeDir));
        new JvmChecker(this.msgLog, new JvmMetadataRepository()).checkJvmCompatibilityAndIssueWarning();
        String cacheTypeName = this.config.get(Configuration.cache_type);
        CacheProvider cacheProvider = this.cacheProviders.get(cacheTypeName);
        if (cacheProvider == null) {
            if (this.config.get(Configuration.cache_type).equals("experimental-off")) {
                cacheProvider = new NoCacheProvider();
            } else {
                throw new IllegalArgumentException("No provider for cache type '" + cacheTypeName + "'. " + "Cache providers are loaded using java service loading where they" + " " + "register themselves in resource (plain-text) files found on the " + "class path under " + "META-INF/services/" + CacheProvider.class.getName() + ". This missing provider may have " + "been caused by either such a missing registration, " + "or by the lack of the provider class itself.");
            }
        }
        this.jobScheduler = this.life.add(this.createJobScheduler());
        this.pageCache = this.createPageCache();
        this.life.add(this.pageCache);
        this.kernelEventHandlers = new KernelEventHandlers(this.logging.getMessagesLog(KernelEventHandlers.class));
        this.caches = this.createCaches();
        this.diagnosticsManager = this.life.add(this.createDiagnosticsManager());
        this.monitors.addMonitorListener(new RollingLogMonitor(){

            @Override
            public void rolledOver() {
                InternalAbstractGraphDatabase.this.diagnosticsManager.dumpAll();
            }
        }, new String[0]);
        this.kernelPanicEventGenerator = new KernelPanicEventGenerator(this.kernelEventHandlers);
        this.kernelHealth = new KernelHealth(this.kernelPanicEventGenerator, this.logging);
        this.dataSourceManager = this.life.add(new DataSourceManager());
        this.createTxHook();
        this.guard = this.config.get(Configuration.execution_guard_enabled) != false ? new Guard(this.msgLog) : null;
        this.lockManager = this.createLockManager();
        this.idGeneratorFactory = this.createIdGeneratorFactory();
        StringLogger messagesLog = this.logging.getMessagesLog(StoreMigrator.class);
        VisibleMigrationProgressMonitor progressMonitor = new VisibleMigrationProgressMonitor(messagesLog, System.out);
        UpgradableDatabase upgradableDatabase = new UpgradableDatabase(new StoreVersionCheck(this.fileSystem));
        this.storeMigrationProcess.addParticipant(new StoreMigrator(progressMonitor, this.fileSystem, upgradableDatabase, this.config, this.logging));
        this.propertyKeyTokenHolder = this.life.add(new PropertyKeyTokenHolder(this.createPropertyKeyCreator()));
        this.labelTokenHolder = this.life.add(new LabelTokenHolder(this.createLabelIdCreator()));
        this.relationshipTypeTokenHolder = this.life.add(new RelationshipTypeTokenHolder(this.createRelationshipTypeCreator()));
        this.caches.configure(cacheProvider, this.config);
        this.diagnosticsManager.tryAppendProvider(this.caches.node());
        this.diagnosticsManager.tryAppendProvider(this.caches.relationship());
        this.threadToTransactionBridge = this.life.add(new ThreadToStatementContextBridge());
        this.nodeManager = this.createNodeManager();
        this.transactionEventHandlers = new TransactionEventHandlers(this.createNodeActions(), this.createRelationshipActions(), this.threadToTransactionBridge);
        this.indexStore = this.life.add(new IndexConfigStore(this.storeDir, this.fileSystem));
        this.diagnosticsManager.prependProvider(this.config);
        this.extensions = this.life.add(this.createKernelData());
        this.life.add(this.kernelExtensions);
        this.schema = new SchemaImpl(this.threadToTransactionBridge);
        LegacyIndexProxy.Lookup indexLookup = this.createIndexLookup();
        IndexProviderImpl indexProvider = new IndexProviderImpl(indexLookup, this.threadToTransactionBridge);
        this.nodeAutoIndexer = this.life.add(new NodeAutoIndexerImpl(this.config, indexProvider, this.nodeManager));
        this.relAutoIndexer = this.life.add(new RelationshipAutoIndexerImpl(this.config, indexProvider, this.nodeManager));
        this.indexManager = new IndexManagerImpl(this.threadToTransactionBridge, indexProvider, this.nodeAutoIndexer, this.relAutoIndexer);
        this.recoveryVerifier = this.createRecoveryVerifier();
        this.storeFactory = this.createStoreFactory();
        this.startupStatistics = new StartupStatisticsProvider();
        this.createNeoDataSource();
        this.life.add(new MonitorGc(this.config, this.msgLog));
        this.life.add(this.nodeManager);
        this.createDatabaseAvailability();
        this.life.add(this.kernelEventHandlers);
        this.dataSourceManager.addListener(new DataSourceManager.Listener(){

            @Override
            public void registered(NeoStoreDataSource dataSource) {
                InternalAbstractGraphDatabase.this.queryExecutor = QueryEngineProvider.initialize(InternalAbstractGraphDatabase.this, InternalAbstractGraphDatabase.this.dependencies.executionEngines());
            }

            @Override
            public void unregistered(NeoStoreDataSource dataSource) {
                InternalAbstractGraphDatabase.this.queryExecutor = QueryEngineProvider.noEngine();
            }
        });
    }

    protected DiagnosticsManager createDiagnosticsManager() {
        return new DiagnosticsManager(this.logging.getMessagesLog(DiagnosticsManager.class));
    }

    protected UpgradeConfiguration createUpgradeConfiguration() {
        return new ConfigMapUpgradeConfiguration(this.config);
    }

    protected Neo4jJobScheduler createJobScheduler() {
        return new Neo4jJobScheduler(this.toString());
    }

    protected LegacyIndexProxy.Lookup createIndexLookup() {
        return new LegacyIndexProxy.Lookup(){

            @Override
            public GraphDatabaseService getGraphDatabaseService() {
                return InternalAbstractGraphDatabase.this;
            }
        };
    }

    protected Monitors createMonitors() {
        return new Monitors();
    }

    @Override
    public void assertSchemaWritesAllowed() throws InvalidTransactionTypeKernelException {
    }

    @Override
    public DependencyResolver getDependencyResolver() {
        return this.dependencyResolver;
    }

    protected TokenCreator createRelationshipTypeCreator() {
        if (this.config.get(GraphDatabaseSettings.read_only).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultRelationshipTypeCreator(this.dataSourceManager, this.idGeneratorFactory);
    }

    protected TokenCreator createPropertyKeyCreator() {
        if (this.config.get(GraphDatabaseSettings.read_only).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultPropertyTokenCreator(this.dataSourceManager, this.idGeneratorFactory);
    }

    protected TokenCreator createLabelIdCreator() {
        if (this.config.get(GraphDatabaseSettings.read_only).booleanValue()) {
            return new ReadOnlyTokenCreator();
        }
        return new DefaultLabelIdCreator(this.dataSourceManager, this.idGeneratorFactory);
    }

    private NodeManager createNodeManager() {
        NodeProxy.NodeActions nodeActions = this.createNodeActions();
        RelationshipProxy.RelationshipActions relationshipLookup = this.createRelationshipActions();
        return new NodeManager(nodeActions, relationshipLookup, this.threadToTransactionBridge);
    }

    @Override
    public boolean isAvailable(long timeout) {
        return this.availabilityGuard.isAvailable(timeout);
    }

    @Override
    public void shutdown() {
        try {
            this.msgLog.info("Shutdown started");
            this.msgLog.flush();
            this.availabilityGuard.shutdown();
            this.life.shutdown();
        }
        catch (LifecycleException throwable) {
            this.msgLog.warn("Shutdown failed", throwable);
            throw throwable;
        }
    }

    protected StoreFactory createStoreFactory() {
        return new StoreFactory(this.config, this.idGeneratorFactory, (PageCache)this.pageCache, this.fileSystem, this.logging.getMessagesLog(StoreFactory.class), this.monitors);
    }

    protected LifecycledPageCache createPageCache() {
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory(this.fileSystem);
        LifecycledPageCache lifecycledPageCache = new LifecycledPageCache((PageSwapperFactory)swapperFactory, this.jobScheduler, this.config, this.tracers.pageCacheTracer);
        if (this.config.get(GraphDatabaseSettings.dump_configuration).booleanValue()) {
            lifecycledPageCache.dumpConfiguration(this.logging.getMessagesLog(PageCache.class));
        }
        return lifecycledPageCache;
    }

    protected RecoveryVerifier createRecoveryVerifier() {
        return RecoveryVerifier.ALWAYS_VALID;
    }

    protected KernelData createKernelData() {
        return new DefaultKernelData(this.config, this);
    }

    protected Caches createCaches() {
        return new DefaultCaches(this.msgLog, this.monitors);
    }

    protected RelationshipProxy.RelationshipActions createRelationshipActions() {
        return new RelationshipProxy.RelationshipActions(){

            @Override
            public GraphDatabaseService getGraphDatabaseService() {
                return InternalAbstractGraphDatabase.this;
            }

            @Override
            public void failTransaction() {
                InternalAbstractGraphDatabase.this.threadToTransactionBridge.getKernelTransactionBoundToThisThread(true).failure();
            }

            @Override
            public void assertInUnterminatedTransaction() {
                InternalAbstractGraphDatabase.this.threadToTransactionBridge.assertInUnterminatedTransaction();
            }

            @Override
            public Statement statement() {
                return InternalAbstractGraphDatabase.this.threadToTransactionBridge.instance();
            }

            @Override
            public Node newNodeProxy(long nodeId) {
                return InternalAbstractGraphDatabase.this.nodeManager.newNodeProxyById(nodeId);
            }

            @Override
            public RelationshipType getRelationshipTypeById(int type) {
                try {
                    return (RelationshipType)InternalAbstractGraphDatabase.this.relationshipTypeTokenHolder.getTokenById(type);
                }
                catch (TokenNotFoundException e) {
                    throw new NotFoundException(e);
                }
            }
        };
    }

    protected NodeProxy.NodeActions createNodeActions() {
        return new NodeProxy.NodeActions(){

            @Override
            public Statement statement() {
                return InternalAbstractGraphDatabase.this.threadToTransactionBridge.instance();
            }

            @Override
            public GraphDatabaseService getGraphDatabase() {
                return InternalAbstractGraphDatabase.this;
            }

            @Override
            public void assertInUnterminatedTransaction() {
                InternalAbstractGraphDatabase.this.threadToTransactionBridge.assertInUnterminatedTransaction();
            }

            @Override
            public void failTransaction() {
                InternalAbstractGraphDatabase.this.threadToTransactionBridge.getKernelTransactionBoundToThisThread(true).failure();
            }

            @Override
            public Relationship lazyRelationshipProxy(long id) {
                return InternalAbstractGraphDatabase.this.nodeManager.newRelationshipProxyById(id);
            }

            @Override
            public Relationship newRelationshipProxy(long id) {
                return InternalAbstractGraphDatabase.this.nodeManager.newRelationshipProxy(id);
            }

            @Override
            public Relationship newRelationshipProxy(long id, long startNodeId, int typeId, long endNodeId) {
                return InternalAbstractGraphDatabase.this.nodeManager.newRelationshipProxy(id, startNodeId, typeId, endNodeId);
            }
        };
    }

    protected void createTxHook() {
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return new DefaultFileSystemAbstraction();
    }

    protected IdGeneratorFactory createIdGeneratorFactory() {
        return new DefaultIdGeneratorFactory();
    }

    protected Locks createLockManager() {
        String key = this.config.get(Configuration.lock_manager);
        for (Locks.Factory candidate : Service.load(Locks.Factory.class)) {
            String candidateId = candidate.getKeys().iterator().next();
            if (candidateId.equals(key)) {
                return candidate.newInstance(ResourceTypes.values());
            }
            if (!key.equals("")) continue;
            this.logging.getMessagesLog(InternalAbstractGraphDatabase.class).info("No locking implementation specified, defaulting to '" + candidateId + "'");
            return candidate.newInstance(ResourceTypes.values());
        }
        if (key.equals("community")) {
            return new CommunityLockManger();
        }
        if (key.equals("")) {
            this.logging.getMessagesLog(InternalAbstractGraphDatabase.class).info("No locking implementation specified, defaulting to 'community'");
            return new CommunityLockManger();
        }
        throw new IllegalArgumentException("No lock manager found with the name '" + key + "'.");
    }

    protected Logging createLogging() {
        return this.life.add(DefaultLogging.createDefaultLogging(this.config, this.monitors));
    }

    protected void createNeoDataSource() {
        this.neoDataSource = new NeoStoreDataSource(this.config, this.storeFactory, this.logging.getMessagesLog(NeoStoreDataSource.class), this.jobScheduler, this.logging, new NonTransactionalTokenNameLookup(this.labelTokenHolder, this.propertyKeyTokenHolder), this.dependencyResolver, this.propertyKeyTokenHolder, this.labelTokenHolder, this.relationshipTypeTokenHolder, this.lockManager, this, this.transactionEventHandlers, this.monitors.newMonitor(IndexingService.Monitor.class, new String[0]), this.fileSystem, this.storeMigrationProcess, this.transactionMonitor, this.kernelHealth, this.monitors.newMonitor(PhysicalLogFile.Monitor.class, new String[0]), this.createHeaderInformationFactory(), this.startupStatistics, this.caches, this.nodeManager, this.guard, this.indexStore, this.getCommitProcessFactory(), this.pageCache, this.monitors, this.tracers);
        this.dataSourceManager.register(this.neoDataSource);
    }

    protected CommitProcessFactory getCommitProcessFactory() {
        return defaultCommitProcessFactory;
    }

    protected TransactionHeaderInformationFactory createHeaderInformationFactory() {
        return TransactionHeaderInformationFactory.DEFAULT;
    }

    @Override
    public final String getStoreDir() {
        return this.storeDir.getPath();
    }

    @Override
    public StoreId storeId() {
        return this.storeId;
    }

    @Override
    public Transaction beginTx() {
        this.availabilityGuard.checkAvailability(this.transactionStartTimeout, org.neo4j.graphdb.TransactionFailureException.class);
        KernelAPI kernel = this.neoDataSource.getKernel();
        TopLevelTransaction topLevelTransaction = this.threadToTransactionBridge.getTopLevelTransactionBoundToThisThread(false);
        if (topLevelTransaction != null) {
            return new PlaceboTransaction(topLevelTransaction);
        }
        try {
            KernelTransaction transaction = kernel.newTransaction();
            topLevelTransaction = new TopLevelTransaction(transaction, this.threadToTransactionBridge);
            this.threadToTransactionBridge.bindTransactionToCurrentThread(topLevelTransaction);
            return topLevelTransaction;
        }
        catch (TransactionFailureException e) {
            throw new org.neo4j.graphdb.TransactionFailureException("Failure to begin transaction", e);
        }
    }

    @Override
    public Result execute(String query) throws QueryExecutionException {
        return this.execute(query, Collections.emptyMap());
    }

    @Override
    public Result execute(String query, Map<String, Object> parameters) throws QueryExecutionException {
        this.availabilityGuard.checkAvailability(this.transactionStartTimeout, org.neo4j.graphdb.TransactionFailureException.class);
        try {
            return this.queryExecutor.executeQuery(query, parameters, QueryEngineProvider.embeddedSession());
        }
        catch (QueryExecutionKernelException e) {
            throw e.asUserException();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.getStoreDir() + "]";
    }

    @Override
    public Iterable<Node> getAllNodes() {
        return GlobalGraphOperations.at(this).getAllNodes();
    }

    @Override
    public Iterable<RelationshipType> getRelationshipTypes() {
        return GlobalGraphOperations.at(this).getAllRelationshipTypes();
    }

    @Override
    public KernelEventHandler registerKernelEventHandler(KernelEventHandler handler) {
        return this.kernelEventHandlers.registerKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> registerTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.transactionEventHandlers.registerTransactionEventHandler(handler);
    }

    @Override
    public KernelEventHandler unregisterKernelEventHandler(KernelEventHandler handler) {
        return this.kernelEventHandlers.unregisterKernelEventHandler(handler);
    }

    @Override
    public <T> TransactionEventHandler<T> unregisterTransactionEventHandler(TransactionEventHandler<T> handler) {
        return this.transactionEventHandlers.unregisterTransactionEventHandler(handler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Node createNode() {
        try (Statement statement = this.threadToTransactionBridge.instance();){
            NodeProxy nodeProxy = this.nodeManager.newNodeProxyById(statement.dataWriteOperations().nodeCreate());
            return nodeProxy;
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Node createNode(Label ... labels) {
        try (Statement statement = this.threadToTransactionBridge.instance();){
            long nodeId = statement.dataWriteOperations().nodeCreate();
            for (Label label : labels) {
                int labelId = statement.tokenWriteOperations().labelGetOrCreateForName(label.name());
                try {
                    statement.dataWriteOperations().nodeAddLabel(nodeId, labelId);
                }
                catch (EntityNotFoundException e) {
                    throw new NotFoundException("No node with id " + nodeId + " found.", e);
                }
            }
            NodeProxy nodeProxy = this.nodeManager.newNodeProxyById(nodeId);
            return nodeProxy;
        }
        catch (ConstraintValidationKernelException e) {
            throw new ConstraintViolationException("Unable to add label.", e);
        }
        catch (SchemaKernelException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    @Override
    public Node getNodeById(long id) {
        if (id < 0L || id > MAX_NODE_ID) {
            throw new NotFoundException(String.format("Node %d not found", id));
        }
        try (Statement statement = this.threadToTransactionBridge.instance();){
            if (!statement.readOperations().nodeExists(id)) {
                throw new NotFoundException(String.format("Node %d not found", id));
            }
            NodeProxy nodeProxy = this.nodeManager.newNodeProxyById(id);
            return nodeProxy;
        }
    }

    @Override
    public Relationship getRelationshipById(long id) {
        if (id < 0L || id > MAX_RELATIONSHIP_ID) {
            throw new NotFoundException(String.format("Relationship %d not found", id));
        }
        try (Statement statement = this.threadToTransactionBridge.instance();){
            if (!statement.readOperations().relationshipExists(id)) {
                throw new NotFoundException(String.format("Relationship %d not found", id));
            }
            RelationshipProxy relationshipProxy = this.nodeManager.newRelationshipProxy(id);
            return relationshipProxy;
        }
    }

    @Override
    public IndexManager index() {
        return this.indexManager;
    }

    @Override
    public Schema schema() {
        this.threadToTransactionBridge.assertInUnterminatedTransaction();
        return this.schema;
    }

    public Config getConfig() {
        return this.config;
    }

    private Iterable<Class<?>> getSettingsClasses(Iterable<Class<?>> settingsClasses, Iterable<KernelExtensionFactory<?>> kernelExtensions, Iterable<CacheProvider> cacheProviders) {
        ArrayList totalSettingsClasses = new ArrayList();
        for (KernelExtensionFactory<?> kernelExtension : kernelExtensions) {
            if (kernelExtension.getSettingsClass() == null) continue;
            totalSettingsClasses.add(kernelExtension.getSettingsClass());
        }
        for (CacheProvider cacheProvider : cacheProviders) {
            if (cacheProvider.getSettingsClass() == null) continue;
            totalSettingsClasses.add(cacheProvider.getSettingsClass());
        }
        return totalSettingsClasses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof InternalAbstractGraphDatabase)) {
            return false;
        }
        InternalAbstractGraphDatabase that = (InternalAbstractGraphDatabase)o;
        return (this.storeId != null ? this.storeId.equals(that.storeId) : that.storeId == null) && this.storeDir.equals(that.storeDir);
    }

    public int hashCode() {
        return this.storeDir.hashCode();
    }

    @Override
    public ResourceIterator<Node> findNodes(Label myLabel, String key, Object value) {
        return this.nodesByLabelAndProperty(myLabel, key, value);
    }

    @Override
    public Node findNode(Label myLabel, String key, Object value) {
        try (ResourceIterator<Node> iterator = this.findNodes(myLabel, key, value);){
            if (!iterator.hasNext()) {
                Node node = null;
                return node;
            }
            Node node = (Node)iterator.next();
            if (iterator.hasNext()) {
                throw new MultipleFoundException();
            }
            Node node2 = node;
            return node2;
        }
    }

    @Override
    public ResourceIterator<Node> findNodes(Label myLabel) {
        return this.allNodesWithLabel(myLabel);
    }

    @Override
    public ResourceIterable<Node> findNodesByLabelAndProperty(final Label myLabel, final String key, final Object value) {
        return new ResourceIterable<Node>(){

            @Override
            public ResourceIterator<Node> iterator() {
                return InternalAbstractGraphDatabase.this.nodesByLabelAndProperty(myLabel, key, value);
            }
        };
    }

    private ResourceIterator<Node> nodesByLabelAndProperty(Label myLabel, String key, Object value) {
        Statement statement = this.threadToTransactionBridge.instance();
        ReadOperations readOps = statement.readOperations();
        int propertyId = readOps.propertyKeyGetForName(key);
        int labelId = readOps.labelGetForName(myLabel.name());
        if (propertyId == -1 || labelId == -1) {
            statement.close();
            return IteratorUtil.emptyIterator();
        }
        IndexDescriptor descriptor = this.findAnyIndexByLabelAndProperty(readOps, propertyId, labelId);
        try {
            if (null != descriptor) {
                return this.map2nodes(readOps.nodesGetFromIndexLookup(descriptor, value), statement);
            }
        }
        catch (IndexNotFoundKernelException e) {
            // empty catch block
        }
        return this.getNodesByLabelAndPropertyWithoutIndex(propertyId, value, statement, labelId);
    }

    private IndexDescriptor findAnyIndexByLabelAndProperty(ReadOperations readOps, int propertyId, int labelId) {
        try {
            IndexDescriptor descriptor = readOps.indexesGetForLabelAndPropertyKey(labelId, propertyId);
            if (readOps.indexGetState(descriptor) == InternalIndexState.ONLINE) {
                return descriptor;
            }
        }
        catch (IndexNotFoundKernelException | SchemaRuleNotFoundException e) {
            // empty catch block
        }
        return null;
    }

    private ResourceIterator<Node> getNodesByLabelAndPropertyWithoutIndex(int propertyId, Object value, Statement statement, int labelId) {
        return this.map2nodes((PrimitiveLongIterator)new PropertyValueFilteringNodeIdIterator(statement.readOperations().nodesGetForLabel(labelId), statement.readOperations(), propertyId, value), statement);
    }

    private ResourceIterator<Node> allNodesWithLabel(Label myLabel) {
        Statement statement = this.threadToTransactionBridge.instance();
        int labelId = statement.readOperations().labelGetForName(myLabel.name());
        if (labelId == -1) {
            statement.close();
            return IteratorUtil.emptyIterator();
        }
        PrimitiveLongIterator nodeIds = statement.readOperations().nodesGetForLabel(labelId);
        return ResourceClosingIterator.newResourceIterator(statement, PrimitiveLongCollections.map((FunctionFromPrimitiveLong)new FunctionFromPrimitiveLong<Node>(){

            public Node apply(long nodeId) {
                return InternalAbstractGraphDatabase.this.nodeManager.newNodeProxyById(nodeId);
            }
        }, (PrimitiveLongIterator)nodeIds));
    }

    private ResourceIterator<Node> map2nodes(PrimitiveLongIterator input, Statement statement) {
        return ResourceClosingIterator.newResourceIterator(statement, PrimitiveLongCollections.map((FunctionFromPrimitiveLong)new FunctionFromPrimitiveLong<Node>(){

            public Node apply(long id) {
                return InternalAbstractGraphDatabase.this.getNodeById(id);
            }
        }, (PrimitiveLongIterator)input));
    }

    @Override
    public TraversalDescription traversalDescription() {
        return new MonoDirectionalTraversalDescription(this.threadToTransactionBridge);
    }

    @Override
    public BidirectionalTraversalDescription bidirectionalTraversalDescription() {
        return new BidirectionalTraversalDescriptionImpl(this.threadToTransactionBridge);
    }

    class DependencyResolverImpl
    extends DependencyResolver.Adapter {
        DependencyResolverImpl() {
        }

        private <T> T resolveKnownSingleDependency(Class<T> type) {
            if (type.equals(Map.class)) {
                return type.cast(InternalAbstractGraphDatabase.this.getConfig().getParams());
            }
            if (type.equals(Config.class)) {
                return type.cast(InternalAbstractGraphDatabase.this.getConfig());
            }
            if (GraphDatabaseService.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this)) {
                return type.cast(InternalAbstractGraphDatabase.this);
            }
            if (QueryExecutionEngine.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.queryExecutor)) {
                return type.cast(InternalAbstractGraphDatabase.this.queryExecutor);
            }
            if (Locks.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.lockManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.lockManager);
            }
            if (LockService.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.neoDataSource.getLockService())) {
                return type.cast(InternalAbstractGraphDatabase.this.neoDataSource.getLockService());
            }
            if (StoreFactory.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.storeFactory)) {
                return type.cast(InternalAbstractGraphDatabase.this.storeFactory);
            }
            if (SchemaWriteGuard.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this);
            }
            if (StringLogger.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.msgLog)) {
                return type.cast(InternalAbstractGraphDatabase.this.msgLog);
            }
            if (Logging.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.logging)) {
                return type.cast(InternalAbstractGraphDatabase.this.logging);
            }
            if (IndexConfigStore.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.indexStore)) {
                return type.cast(InternalAbstractGraphDatabase.this.indexStore);
            }
            if (DataSourceManager.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.dataSourceManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.dataSourceManager);
            }
            if (FileSystemAbstraction.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.fileSystem)) {
                return type.cast(InternalAbstractGraphDatabase.this.fileSystem);
            }
            if (PageCache.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.pageCache.unwrap());
            }
            if (Guard.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.guard)) {
                return type.cast(InternalAbstractGraphDatabase.this.guard);
            }
            if (IndexProviders.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.neoDataSource)) {
                return type.cast(InternalAbstractGraphDatabase.this.neoDataSource);
            }
            if (KernelData.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.extensions)) {
                return type.cast(InternalAbstractGraphDatabase.this.extensions);
            }
            if (KernelExtensions.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.kernelExtensions)) {
                return type.cast(InternalAbstractGraphDatabase.this.kernelExtensions);
            }
            if (NodeManager.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.nodeManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.nodeManager);
            }
            if (DiagnosticsManager.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.diagnosticsManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.diagnosticsManager);
            }
            if (RelationshipTypeTokenHolder.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.relationshipTypeTokenHolder)) {
                return type.cast(InternalAbstractGraphDatabase.this.relationshipTypeTokenHolder);
            }
            if (PropertyKeyTokenHolder.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.propertyKeyTokenHolder)) {
                return type.cast(InternalAbstractGraphDatabase.this.propertyKeyTokenHolder);
            }
            if (LabelTokenHolder.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.labelTokenHolder)) {
                return type.cast(InternalAbstractGraphDatabase.this.labelTokenHolder);
            }
            if (KernelPanicEventGenerator.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.kernelPanicEventGenerator);
            }
            if (LifeSupport.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.life);
            }
            if (Monitors.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.monitors);
            }
            if (ThreadToStatementContextBridge.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.threadToTransactionBridge)) {
                return type.cast(InternalAbstractGraphDatabase.this.threadToTransactionBridge);
            }
            if (CacheAccessBackDoor.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.cacheBridge)) {
                return type.cast(InternalAbstractGraphDatabase.this.cacheBridge);
            }
            if (StoreLockerLifecycleAdapter.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.storeLocker)) {
                return type.cast(InternalAbstractGraphDatabase.this.storeLocker);
            }
            if (IndexManager.class.equals(type) && type.isInstance(InternalAbstractGraphDatabase.this.indexManager)) {
                return type.cast(InternalAbstractGraphDatabase.this.indexManager);
            }
            if (IndexingService.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.neoDataSource.getIndexService())) {
                return type.cast(InternalAbstractGraphDatabase.this.neoDataSource.getIndexService());
            }
            if (JobScheduler.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.jobScheduler)) {
                return type.cast(InternalAbstractGraphDatabase.this.jobScheduler);
            }
            if (KernelAPI.class.equals(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.neoDataSource.getKernel());
            }
            if (LabelScanStore.class.isAssignableFrom(type) && type.isInstance(InternalAbstractGraphDatabase.this.neoDataSource.getLabelScanStore())) {
                return type.cast(InternalAbstractGraphDatabase.this.neoDataSource.getLabelScanStore());
            }
            if (NeoStoreProvider.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.neoDataSource);
            }
            if (IdGeneratorFactory.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.idGeneratorFactory);
            }
            if (Monitors.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.monitors);
            }
            if (TransactionEventHandlers.class.equals(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.transactionEventHandlers);
            }
            if (DependencyResolver.class.equals(type)) {
                return type.cast(this);
            }
            if (KernelHealth.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.kernelHealth);
            }
            if (StoreUpgrader.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.storeMigrationProcess);
            }
            if (StoreId.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.storeId);
            }
            if (AvailabilityGuard.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.availabilityGuard);
            }
            if (StartupStatistics.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.startupStatistics);
            }
            if (TransactionMonitor.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.transactionMonitor);
            }
            if (PageCacheMonitor.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.tracers.pageCacheTracer);
            }
            if (Caches.class.isAssignableFrom(type)) {
                return type.cast(InternalAbstractGraphDatabase.this.caches);
            }
            return null;
        }

        @Override
        public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
            T result = this.resolveKnownSingleDependency(type);
            if (result != null) {
                return selector.select(type, Iterables.option(result));
            }
            try {
                result = InternalAbstractGraphDatabase.this.neoDataSource.getDependencyResolver().resolveDependency(type, selector);
                if (result != null) {
                    return selector.select(type, Iterables.option(result));
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            return InternalAbstractGraphDatabase.this.kernelExtensions.resolveDependency(type, selector);
        }
    }

    protected final class DefaultKernelData
    extends KernelData
    implements Lifecycle {
        private final GraphDatabaseAPI graphDb;

        public DefaultKernelData(Config config, GraphDatabaseAPI graphDb) {
            super(config);
            this.graphDb = graphDb;
        }

        @Override
        public Version version() {
            return Version.getKernel();
        }

        @Override
        public GraphDatabaseAPI graphDatabase() {
            return this.graphDb;
        }

        @Override
        public void init() throws Throwable {
        }

        @Override
        public void start() throws Throwable {
        }

        @Override
        public void stop() throws Throwable {
        }
    }

    private static class PropertyValueFilteringNodeIdIterator
    extends PrimitiveLongCollections.PrimitiveLongBaseIterator {
        private final PrimitiveLongIterator nodesWithLabel;
        private final ReadOperations statement;
        private final int propertyKeyId;
        private final Object value;

        PropertyValueFilteringNodeIdIterator(PrimitiveLongIterator nodesWithLabel, ReadOperations statement, int propertyKeyId, Object value) {
            this.nodesWithLabel = nodesWithLabel;
            this.statement = statement;
            this.propertyKeyId = propertyKeyId;
            this.value = value;
        }

        protected boolean fetchNext() {
            boolean hasNext = this.nodesWithLabel.hasNext();
            while (hasNext) {
                long nextValue = this.nodesWithLabel.next();
                try {
                    if (this.statement.nodeGetProperty(nextValue, this.propertyKeyId).valueEquals(this.value)) {
                        return this.next(nextValue);
                    }
                }
                catch (EntityNotFoundException e) {
                    // empty catch block
                }
                hasNext = this.nodesWithLabel.hasNext();
            }
            return false;
        }
    }

    public static class Configuration {
        public static final Setting<Boolean> read_only = GraphDatabaseSettings.read_only;
        public static final Setting<Boolean> execution_guard_enabled = GraphDatabaseSettings.execution_guard_enabled;
        public static final Setting<String> cache_type = GraphDatabaseSettings.cache_type;
        public static final Setting<Boolean> ephemeral = Settings.setting("ephemeral", Settings.BOOLEAN, "false");
        public static final Setting<String> ephemeral_keep_logical_logs = Settings.setting("keep_logical_logs", Settings.STRING, "1 files", Settings.illegalValueMessage("must be `true`/`false` or of format '<number><optional unit> <type>' for example `100M size` for limiting logical log space on disk to 100Mb, or `200k txs` for limiting the number of transactions to keep to 200 000", Settings.matches(".+")));
        public static final Setting<File> store_dir = GraphDatabaseSettings.store_dir;
        public static final Setting<File> neo_store = GraphDatabaseSettings.neo_store;
        public static final Setting<String> lock_manager = Settings.setting("lock_manager", Settings.STRING, "");
        public static final Setting<String> log_configuration_file = Settings.setting("log.configuration", Settings.STRING, "neo4j-logback.xml");
        public static final Setting<String> tracer = Settings.setting("dbms.tracer", Settings.STRING, (String)null);
    }

    public static interface Dependencies {
        public Monitors monitors();

        public Logging logging();

        public Iterable<Class<?>> settingsClasses();

        public Iterable<KernelExtensionFactory<?>> kernelExtensions();

        public Iterable<CacheProvider> cacheProviders();

        public Iterable<QueryEngineProvider> executionEngines();
    }
}

