/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store.io;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.unsafe.impl.batchimport.IoThroughputStat;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;

public class IoMonitor
implements StatsProvider,
Monitor {
    private volatile long startTime = System.currentTimeMillis();
    private volatile long endTime;
    private final AtomicLong totalWritten = new AtomicLong();

    @Override
    public void dataWritten(int bytes) {
        this.totalWritten.addAndGet(bytes);
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
        this.totalWritten.set(0L);
    }

    public void stop() {
        this.endTime = System.currentTimeMillis();
    }

    public long startTime() {
        return this.startTime;
    }

    public long totalBytesWritten() {
        return this.totalWritten.get();
    }

    @Override
    public Stat stat(Key key) {
        if (key == Keys.io_throughput) {
            return new IoThroughputStat(this.startTime, this.endTime, this.totalWritten.get());
        }
        return null;
    }

    @Override
    public Key[] keys() {
        return new Key[]{Keys.io_throughput};
    }
}

