/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.collection.pool.Pool;
import org.neo4j.helpers.Factory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.util.SimplePool;
import org.neo4j.unsafe.impl.batchimport.Parallelizable;
import org.neo4j.unsafe.impl.batchimport.WriterFactories;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;

public class BatchingPageCache
implements PageCache {
    public static final WriterFactory SYNCHRONOUS = new WriterFactories.SingleThreadedWriterFactory(){

        @Override
        public Writer create(final StoreChannel channel, final Monitor monitor) {
            return new Writer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void write(ByteBuffer data, long position, Pool<ByteBuffer> poolToReleaseBufferIn) throws IOException {
                    try {
                        int written = channel.write(data, position);
                        monitor.dataWritten(written);
                    }
                    finally {
                        poolToReleaseBufferIn.release((Object)data);
                    }
                }
            };
        }

        @Override
        public void awaitEverythingWritten() {
        }

        @Override
        public void shutdown() {
        }

        public String toString() {
            return "SYNCHRONOUS";
        }
    };
    private final int pageSize;
    private final FileSystemAbstraction fs;
    private final Map<File, BatchingPagedFile> pagedFiles = new HashMap<File, BatchingPagedFile>();
    private final WriterFactory writerFactory;
    private final Monitor monitor;
    private Mode mode;
    private static final ByteBuffer ZEROS = ByteBuffer.allocateDirect(4096);

    public BatchingPageCache(FileSystemAbstraction fs, int pageSize, WriterFactory writerFactory, Monitor monitor, Mode mode) {
        this.fs = fs;
        this.pageSize = pageSize;
        this.writerFactory = writerFactory;
        this.monitor = monitor;
        this.mode = mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public PagedFile map(File file, int pageSize) throws IOException {
        StoreChannel channel = this.fs.open(file, "rw");
        Writer writer = file.getName().contains(".counts.db") ? SYNCHRONOUS.create(channel, this.monitor) : this.writerFactory.create(channel, this.monitor);
        BatchingPagedFile pageFile = new BatchingPagedFile(file, channel, writer, this.individualizedPageSize(file, pageSize));
        this.pagedFiles.put(file, pageFile);
        return pageFile;
    }

    private int individualizedPageSize(File file, int pageSize) {
        return file.getName().endsWith(".relationshipstore.db") ? pageSize * 50 : pageSize;
    }

    void unmap(BatchingPagedFile pagedFile) throws IOException {
        File file = pagedFile.file;
        BatchingPagedFile pageFile = this.pagedFiles.remove(file);
        if (pageFile == null) {
            throw new IllegalArgumentException(file.toString());
        }
        pageFile.closeFile();
    }

    public void flush() throws IOException {
        for (PagedFile pagedFile : this.pagedFiles.values()) {
            pagedFile.flush();
        }
    }

    public void close() throws IOException {
        for (BatchingPagedFile pagedFile : this.pagedFiles.values()) {
            pagedFile.close();
        }
        this.pagedFiles.clear();
    }

    public int pageSize() {
        return this.pageSize;
    }

    public int maxCachedPages() {
        return 1;
    }

    private static void zeroBuffer(ByteBuffer buffer) {
        ByteBuffer zeros = ZEROS.duplicate();
        buffer.clear();
        while (buffer.hasRemaining()) {
            int chunkSize = Math.min(buffer.remaining(), zeros.capacity());
            zeros.clear();
            zeros.limit(chunkSize);
            buffer.put(zeros);
        }
    }

    class BatchingPageCursor
    implements PageCursor {
        private ByteBuffer currentBuffer;
        private final SimplePool<ByteBuffer> bufferPool;
        private final StoreChannel channel;
        private final Writer writer;
        private long currentPageId = -1L;
        private final int pageSize;
        private boolean pinned;
        private long highestKnownPageId;
        private boolean changed;

        BatchingPageCursor(StoreChannel channel, Writer writer, final int pageSize) throws IOException {
            this.channel = channel;
            this.writer = writer;
            this.pageSize = pageSize;
            this.bufferPool = new SimplePool<ByteBuffer>(2, new Factory<ByteBuffer>(){

                public ByteBuffer newInstance() {
                    return ByteBuffer.allocateDirect(pageSize);
                }
            });
            this.currentBuffer = this.bufferPool.acquire();
            this.highestKnownPageId = channel.size() / (long)pageSize;
        }

        public byte getByte() {
            return this.currentBuffer.get();
        }

        public byte getByte(int offset) {
            return this.currentBuffer.get(offset);
        }

        public void putByte(byte value) {
            this.currentBuffer.put(value);
            this.changed = true;
        }

        public void putByte(int offset, byte value) {
            this.currentBuffer.put(offset, value);
        }

        public long getLong() {
            return this.currentBuffer.getLong();
        }

        public long getLong(int offset) {
            return this.currentBuffer.getLong(offset);
        }

        public void putLong(long value) {
            this.currentBuffer.putLong(value);
            this.changed = true;
        }

        public void putLong(int offset, long value) {
            this.currentBuffer.putLong(offset, value);
        }

        public int getInt() {
            return this.currentBuffer.getInt();
        }

        public int getInt(int offset) {
            return this.currentBuffer.getInt(offset);
        }

        public void putInt(int value) {
            this.currentBuffer.putInt(value);
            this.changed = true;
        }

        public void putInt(int offset, int value) {
            this.currentBuffer.putInt(offset, value);
        }

        public long getUnsignedInt() {
            return (long)this.getInt() & 0xFFFFFFFFL;
        }

        public long getUnsignedInt(int offset) {
            return (long)this.getInt(offset) & 0xFFFFFFFFL;
        }

        public void getBytes(byte[] data) {
            this.currentBuffer.get(data);
        }

        public void putBytes(byte[] data) {
            this.currentBuffer.put(data);
            this.changed = true;
        }

        public short getShort() {
            return this.currentBuffer.getShort();
        }

        public short getShort(int offset) {
            return this.currentBuffer.getShort(offset);
        }

        public void putShort(short value) {
            this.currentBuffer.putShort(value);
            this.changed = true;
        }

        public void putShort(int offset, short value) {
            this.currentBuffer.putShort(offset, value);
        }

        public void setOffset(int offset) {
            this.currentBuffer.position(offset);
        }

        public int getOffset() {
            return this.currentBuffer.position();
        }

        public long getCurrentPageId() {
            return this.currentPageId;
        }

        public void rewind() throws IOException {
            throw new UnsupportedOperationException("Unsupported in this batching page cache, since it's all about strictly sequential access");
        }

        public boolean next() throws IOException {
            return this.next(this.currentPageId + 1L);
        }

        public boolean next(long pageId) throws IOException {
            if (!this.pinned) {
                this.pinned = true;
                return true;
            }
            this.ensurePagePlacedOver(pageId);
            return true;
        }

        public void close() {
        }

        public boolean shouldRetry() {
            return false;
        }

        private void ensurePagePlacedOver(long pageId) throws IOException {
            if (pageId == this.currentPageId) {
                return;
            }
            this.flush();
            if (BatchingPageCache.this.mode.canReadFrom(pageId)) {
                this.readFromChannelIntoBuffer(pageId);
            } else {
                BatchingPageCache.zeroBuffer(this.currentBuffer);
            }
            this.currentPageId = pageId;
            this.highestKnownPageId = Math.max(this.highestKnownPageId, pageId);
            this.prepared(this.currentBuffer);
        }

        private void readFromChannelIntoBuffer(long pageId) throws IOException {
            this.channel.read(this.prepared(this.currentBuffer), pageId * (long)this.pageSize);
        }

        private void flush() throws IOException {
            if (this.currentPageId == -1L) {
                return;
            }
            if (this.changed) {
                this.writer.write(this.prepared(this.currentBuffer), this.currentPageId * (long)this.pageSize, this.bufferPool);
                this.currentBuffer = this.bufferPool.acquire();
                this.changed = false;
            }
            this.currentPageId = -1L;
        }

        private ByteBuffer prepared(ByteBuffer buffer) {
            buffer.flip();
            buffer.limit(this.pageSize);
            return buffer;
        }

        public long highestKnownPageId() {
            return this.highestKnownPageId;
        }
    }

    class BatchingPagedFile
    implements PagedFile {
        private final BatchingPageCursor singleCursor;
        private final File file;
        private final StoreChannel channel;
        private final int pageSize;

        public BatchingPagedFile(File file, StoreChannel channel, Writer writer, int pageSize) throws IOException {
            this.file = file;
            this.channel = channel;
            this.pageSize = pageSize;
            this.singleCursor = new BatchingPageCursor(channel, writer, pageSize);
        }

        public PageCursor io(long pageId, int pf_flags) throws IOException {
            this.singleCursor.ensurePagePlacedOver(pageId);
            this.singleCursor.pinned = false;
            return this.singleCursor;
        }

        public int pageSize() {
            return this.pageSize;
        }

        public void close() throws IOException {
            BatchingPageCache.this.unmap(this);
        }

        public void closeFile() throws IOException {
            this.flush();
            this.channel.close();
        }

        public void flush() throws IOException {
            this.singleCursor.flush();
        }

        public void force() throws IOException {
        }

        public long getLastPageId() throws IOException {
            return this.singleCursor.highestKnownPageId();
        }
    }

    public static enum Mode {
        APPEND_ONLY{

            @Override
            boolean canReadFrom(long pageId) {
                return pageId == 0L;
            }
        }
        ,
        UPDATE{

            @Override
            boolean canReadFrom(long pageId) {
                return true;
            }
        };


        abstract boolean canReadFrom(long var1);
    }

    public static interface Writer {
        public void write(ByteBuffer var1, long var2, Pool<ByteBuffer> var4) throws IOException;
    }

    public static interface WriterFactory
    extends Parallelizable {
        public Writer create(StoreChannel var1, Monitor var2);

        public void awaitEverythingWritten();

        public void shutdown();
    }
}

