/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.Collection;
import org.neo4j.unsafe.impl.batchimport.InputIterator;
import org.neo4j.unsafe.impl.batchimport.IoThroughputStat;
import org.neo4j.unsafe.impl.batchimport.staging.ProducerStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.Key;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class IteratorBatcherStep<T>
extends ProducerStep<T>
implements StatsProvider {
    private final InputIterator<T> data;

    public IteratorBatcherStep(StageControl control, String name, int batchSize, int movingAverageSize, InputIterator<T> data, Class<T> itemClass) {
        super(control, name, batchSize, movingAverageSize, itemClass);
        this.data = data;
    }

    @Override
    protected T nextOrNull() {
        return this.data.hasNext() ? (T)this.data.next() : null;
    }

    @Override
    public void close() {
        this.data.close();
    }

    @Override
    protected void addStatsProviders(Collection<StatsProvider> providers) {
        super.addStatsProviders(providers);
        providers.add(this);
    }

    @Override
    public Stat stat(Key key) {
        if (key == Keys.io_throughput) {
            return new IoThroughputStat(this.startTime, this.endTime, this.data.position());
        }
        return null;
    }

    @Override
    public Key[] keys() {
        return new Key[]{Keys.io_throughput};
    }
}

