/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.function.primitive.PrimitiveLongPredicate;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.util.MovingAverage;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.staging.Step;
import org.neo4j.unsafe.impl.batchimport.stats.ProcessingStats;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public abstract class AbstractStep<T>
implements Step<T> {
    private final StageControl control;
    private final String name;
    private volatile Step downstream;
    private volatile boolean endOfUpstream;
    private volatile Throwable panic;
    private volatile boolean completed;
    protected boolean orderedTickets;
    protected final PrimitiveLongPredicate rightTicket = new PrimitiveLongPredicate(){

        public boolean accept(long ticket) {
            return AbstractStep.this.doneBatches.get() == ticket - 1L;
        }
    };
    protected final AtomicLong downstreamIdleTime = new AtomicLong();
    protected final AtomicLong upstreamIdleTime = new AtomicLong();
    protected final AtomicInteger queuedBatches = new AtomicInteger();
    protected final AtomicLong doneBatches = new AtomicLong();
    protected final MovingAverage totalProcessingTime;
    protected long startTime;
    protected long endTime;

    public AbstractStep(StageControl control, String name, int movingAverageSize) {
        this.control = control;
        this.name = name;
        this.totalProcessingTime = new MovingAverage(movingAverageSize);
    }

    @Override
    public void start(boolean orderedTickets) {
        this.orderedTickets = orderedTickets;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public int numberOfProcessors() {
        return 1;
    }

    @Override
    public boolean incrementNumberOfProcessors() {
        return false;
    }

    @Override
    public boolean decrementNumberOfProcessors() {
        return false;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void receivePanic(Throwable cause) {
        this.panic = cause;
    }

    protected boolean stillWorking() {
        if (this.panic != null) {
            return false;
        }
        return !this.endOfUpstream || this.queuedBatches.get() != 0;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    protected void issuePanic(Throwable cause) {
        this.issuePanic(cause, true);
    }

    protected void issuePanic(Throwable cause, boolean rethrow) {
        this.control.panic(cause);
        if (rethrow) {
            throw Exceptions.launderedException(cause);
        }
    }

    protected long await(PrimitiveLongPredicate predicate, long value) {
        if (predicate.accept(value)) {
            return 0L;
        }
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 1000000 && !predicate.accept(value); ++i) {
        }
        while (!predicate.accept(value)) {
            try {
                Thread.sleep(1L);
                Thread.yield();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.assertHealthy();
        }
        return System.currentTimeMillis() - startTime;
    }

    protected void assertHealthy() {
        if (this.panic != null) {
            throw new RuntimeException("Panic called, so exiting", this.panic);
        }
    }

    @Override
    public void setDownstream(Step<?> downstream) {
        this.downstream = downstream;
    }

    @Override
    public StepStats stats() {
        ArrayList<StatsProvider> providers = new ArrayList<StatsProvider>();
        this.addStatsProviders(providers);
        return new StepStats(this.name, this.stillWorking(), providers);
    }

    protected void addStatsProviders(Collection<StatsProvider> providers) {
        providers.add(new ProcessingStats(this.doneBatches.get() + (long)this.queuedBatches.get(), this.doneBatches.get(), this.totalProcessingTime.total(), this.totalProcessingTime.average() / (long)this.numberOfProcessors(), this.upstreamIdleTime.get(), this.downstreamIdleTime.get()));
    }

    protected <BATCH> void sendDownstream(long ticket, BATCH batch) {
        if (batch == null) {
            if (this.downstream != null) {
                throw new IllegalArgumentException("Expected a batch to send downstream");
            }
        } else {
            this.downstreamIdleTime.addAndGet(this.downstream.receive(ticket, batch));
        }
    }

    @Override
    public void endOfUpstream() {
        this.endOfUpstream = true;
        this.checkNotifyEndDownstream();
    }

    protected void checkNotifyEndDownstream() {
        if (!this.stillWorking() && !this.isCompleted()) {
            if (this.downstream != null) {
                this.downstream.endOfUpstream();
            }
            this.done();
            this.completed = true;
        }
    }

    protected void done() {
        this.endTime = System.currentTimeMillis();
    }

    @Override
    public void close() {
    }
}

