/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Clock;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;

abstract class AbstractExecutionMonitor
implements ExecutionMonitor {
    private final Clock clock;
    private final long intervalMillis;

    protected AbstractExecutionMonitor(Clock clock, long time, TimeUnit unit) {
        this.clock = clock;
        this.intervalMillis = unit.toMillis(time);
    }

    protected AbstractExecutionMonitor(long time, TimeUnit unit) {
        this(Clock.SYSTEM_CLOCK, time, unit);
    }

    @Override
    public long nextCheckTime() {
        return this.clock.currentTimeMillis() + this.intervalMillis;
    }

    @Override
    public void start(StageExecution[] executions) {
    }

    @Override
    public void end(StageExecution[] executions, long totalTimeMillis) {
    }

    @Override
    public void done(long totalTimeMillis) {
    }
}

