/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.function.Function;
import org.neo4j.function.Functions;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.UpdateBehaviour;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputNodeDeserializer;

public class ExternalPropertiesDecorator
implements Function<InputNode, InputNode> {
    private final InputNodeDeserializer deserializer;
    private InputNode currentExternal;
    private final UpdateBehaviour updateBehaviour;

    public ExternalPropertiesDecorator(DataFactory<InputNode> data, Header.Factory headerFactory, Configuration config, IdType idType, UpdateBehaviour updateBehaviour) {
        this.updateBehaviour = updateBehaviour;
        CharSeeker dataStream = data.create(config).stream();
        Header header = headerFactory.create(dataStream, config, idType);
        this.deserializer = new InputNodeDeserializer(header, dataStream, config.delimiter(), (Function<InputNode, InputNode>)Functions.identity(), idType.idsAreExternal(), new Groups());
    }

    public InputNode apply(InputNode from) throws RuntimeException {
        Object id = from.id();
        if (this.currentExternal != null) {
            if (id.equals(this.currentExternal.id())) {
                this.decorate(from);
                this.currentExternal = null;
            } else {
                return from;
            }
        }
        while (this.deserializer.hasNext()) {
            this.currentExternal = (InputNode)this.deserializer.next();
            if (!id.equals(this.currentExternal.id())) break;
            this.decorate(from);
        }
        return from;
    }

    private void decorate(InputNode from) {
        from.updateProperties(this.updateBehaviour, this.currentExternal.properties());
    }
}

