/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import org.neo4j.function.primitive.PrimitiveIntPredicate;

public interface Group
extends PrimitiveIntPredicate {
    public static final Group GLOBAL = new Adapter(0, "global group"){

        @Override
        public boolean accept(int value) {
            return true;
        }
    };

    public int id();

    public String name();

    public String toString();

    public static class Adapter
    implements Group {
        private final int id;
        private final String name;

        public Adapter(int id, String name) {
            this.id = id;
            this.name = name;
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public String name() {
            return this.name;
        }

        public boolean accept(int value) {
            return value == this.id;
        }

        @Override
        public String toString() {
            return "(" + this.name + "," + this.id + ")";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Adapter other = (Adapter)obj;
            return this.id == other.id;
        }
    }
}

