/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.RadixCalculator;

public abstract class Radix {
    protected final int[] radixIndexCount = new int[(int)Math.pow(2.0, 23.0)];

    public int registerRadixOf(long value) {
        int radix;
        int n = radix = this.calculator().radixOf(value);
        this.radixIndexCount[n] = this.radixIndexCount[n] + 1;
        return radix;
    }

    public int[] getRadixIndexCounts() {
        return this.radixIndexCount;
    }

    public abstract RadixCalculator calculator();

    public java.lang.String toString() {
        return Radix.class.getSimpleName() + "." + this.getClass().getSimpleName();
    }

    public static class Long
    extends Radix {
        private final Register.IntRegister radixShift = Registers.newIntRegister((int)0);
        private final RadixCalculator calculator = new RadixCalculator.Long((Register.Int.In)this.radixShift);

        @Override
        public RadixCalculator calculator() {
            return this.calculator;
        }

        @Override
        public int registerRadixOf(long value) {
            this.radixOverflow(value);
            return super.registerRadixOf(value);
        }

        private void radixOverflow(long val) {
            long shiftVal = (val & 0x1FFFFFFFFFFFFFFL) >> 23 + this.radixShift.read();
            if (shiftVal > 0L) {
                while (shiftVal > 0L) {
                    this.radixShift.increment(1);
                    this.compressRadixIndex();
                    shiftVal >>= 1;
                }
            }
        }

        private void compressRadixIndex() {
            int i;
            for (i = 0; i < this.radixIndexCount.length / 2; ++i) {
                this.radixIndexCount[i] = this.radixIndexCount[2 * i] + this.radixIndexCount[2 * i + 1];
            }
            for (i = this.radixIndexCount.length / 2; i < this.radixIndexCount.length; ++i) {
                this.radixIndexCount[i] = 0;
            }
        }
    }

    public static class String
    extends Radix {
        private final RadixCalculator calculator = new RadixCalculator.String();

        @Override
        public RadixCalculator calculator() {
            return this.calculator;
        }
    }
}

