/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.function.primitive.PrimitiveIntPredicate;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.unsafe.impl.batchimport.Utils;
import org.neo4j.unsafe.impl.batchimport.cache.IntArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongBitsManipulator;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.CollisionHandler;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Encoder;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.IdGroup;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.ParallelSort;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.Radix;
import org.neo4j.unsafe.impl.batchimport.input.Group;

public class EncodingIdMapper
implements IdMapper {
    private static LongBitsManipulator COLLISION_BIT = new LongBitsManipulator(56, 1);
    public static int CACHE_CHUNK_SIZE = 1000000;
    private final LongArray dataCache;
    private final IntArray trackerCache;
    private final Encoder encoder;
    private final Radix radix;
    private final int processorsForSorting;
    private final LongArray collisionCache;
    private final List<Object> collisionValues = new ArrayList<Object>();
    private boolean readyForUse;
    private long[][] sortBuckets;
    private long size;
    private IdGroup[] idGroups = new IdGroup[10];
    private IdGroup currentIdGroup;
    private int idGroupsCursor;

    public EncodingIdMapper(NumberArrayFactory cacheFactory, Encoder encoder, Radix radix) {
        this(cacheFactory, encoder, radix, CACHE_CHUNK_SIZE, Runtime.getRuntime().availableProcessors() - 1);
    }

    public EncodingIdMapper(NumberArrayFactory cacheFactory, Encoder encoder, Radix radix, int chunkSize, int processorsForSorting) {
        this.processorsForSorting = Math.max(processorsForSorting, 1);
        this.dataCache = EncodingIdMapper.newLongArray(cacheFactory, chunkSize);
        this.trackerCache = EncodingIdMapper.newIntArray(cacheFactory, chunkSize);
        this.encoder = encoder;
        this.radix = radix;
        this.collisionCache = EncodingIdMapper.newLongArray(cacheFactory, chunkSize);
    }

    private static IntArray newIntArray(NumberArrayFactory cacheFactory, int chunkSize) {
        return cacheFactory.newDynamicIntArray(chunkSize, -1);
    }

    private static LongArray newLongArray(NumberArrayFactory cacheFactory, int chunkSize) {
        return cacheFactory.newDynamicLongArray(chunkSize, -1L);
    }

    @Override
    public long get(Object inputId, Group group) {
        assert (this.readyForUse);
        return this.binarySearch(inputId, group);
    }

    @Override
    public void put(Object inputId, long id, Group group) {
        int groupId = group.id();
        boolean newGroup = false;
        if (this.currentIdGroup == null) {
            newGroup = true;
        } else {
            if (groupId < this.currentIdGroup.id()) {
                throw new IllegalStateException("Nodes for any specific group must be added in sequence before adding nodes for any other group");
            }
            boolean bl = newGroup = groupId != this.currentIdGroup.id();
        }
        if (newGroup) {
            this.endPreviousGroup();
        }
        long code = this.encoder.encode(inputId);
        this.dataCache.set(id, code);
        this.radix.registerRadixOf(code);
        ++this.size;
        if (newGroup) {
            if (this.idGroupsCursor >= this.idGroups.length) {
                this.idGroups = Arrays.copyOf(this.idGroups, this.idGroups.length * 2);
            }
            this.idGroups[this.idGroupsCursor++] = this.currentIdGroup = new IdGroup(group, this.dataCache.highestSetIndex());
        }
    }

    private void endPreviousGroup() {
        if (this.idGroupsCursor > 0) {
            this.idGroups[this.idGroupsCursor - 1].setHighDataIndex(this.dataCache.highestSetIndex());
        }
    }

    @Override
    public boolean needsPreparation() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(ResourceIterable<Object> ids) {
        this.endPreviousGroup();
        EncodingIdMapper encodingIdMapper = this;
        synchronized (encodingIdMapper) {
            this.sortBuckets = new ParallelSort(this.radix, this.dataCache, this.trackerCache, this.processorsForSorting).run();
        }
        if (this.detectAndMarkCollisions() > 0) {
            try (ResourceIterator<Object> idIterator = ids.iterator();){
                this.buildCollisionInfo(idIterator);
            }
        }
        this.readyForUse = true;
    }

    private int radixOf(long value) {
        return this.radix.calculator().radixOf(value);
    }

    private long binarySearch(Object inputId, PrimitiveIntPredicate inGroup) {
        long returnVal;
        long highestSetTrackerIndex;
        long low = 0L;
        long high = highestSetTrackerIndex = this.trackerCache.highestSetIndex();
        long x = this.encoder.encode(inputId);
        int rIndex = this.radixOf(x);
        for (int k = 0; k < this.sortBuckets.length; ++k) {
            if ((long)rIndex > this.sortBuckets[k][0]) continue;
            low = this.sortBuckets[k][1];
            high = k == this.sortBuckets.length - 1 ? this.trackerCache.size() - 1L : this.sortBuckets[k + 1][1];
            break;
        }
        if ((returnVal = this.binarySearch(x, inputId, low, high, inGroup)) == -1L) {
            low = 0L;
            high = this.trackerCache.size() - 1L;
            returnVal = this.binarySearch(x, inputId, low, high, inGroup);
        }
        return returnVal;
    }

    private static long setCollision(long value) {
        return COLLISION_BIT.set(value, 1, 1L);
    }

    static long clearCollision(long value) {
        return COLLISION_BIT.clear(value, 1, false);
    }

    private static boolean isCollision(long value) {
        return COLLISION_BIT.get(value, 1) != 0L;
    }

    private int detectAndMarkCollisions() {
        int numCollisions = 0;
        int i = 0;
        while ((long)i < this.trackerCache.size() - 1L) {
            if (EncodingIdMapper.compareDataCache(this.dataCache, this.trackerCache, i, i + 1, Utils.CompareType.GE)) {
                if (!EncodingIdMapper.compareDataCache(this.dataCache, this.trackerCache, i, i + 1, Utils.CompareType.EQ)) {
                    throw new IllegalStateException("Failure:[" + i + "] " + Long.toHexString(this.dataCache.get(this.trackerCache.get(i))) + ":" + Long.toHexString(this.dataCache.get(this.trackerCache.get(i + 1))) + " | " + this.radixOf(this.dataCache.get(this.trackerCache.get(i))) + ":" + this.radixOf(this.dataCache.get(this.trackerCache.get(i + 1))));
                }
                if (this.trackerCache.get(i) > this.trackerCache.get(i + 1)) {
                    this.trackerCache.swap(i, i + 1, 1);
                }
                long value = this.dataCache.get(this.trackerCache.get(i));
                value = EncodingIdMapper.setCollision(value);
                this.dataCache.set(this.trackerCache.get(i), value);
                value = this.dataCache.get(this.trackerCache.get(i + 1));
                value = EncodingIdMapper.setCollision(value);
                this.dataCache.set(this.trackerCache.get(i + 1), value);
                ++numCollisions;
            }
            ++i;
        }
        return numCollisions;
    }

    private void buildCollisionInfo(Iterator<Object> ids) {
        PrimitiveIntObjectMap collidedIds = Primitive.intObjectMap();
        long i = 0L;
        while (ids.hasNext()) {
            Object id = ids.next();
            long value = this.dataCache.get(i);
            if (EncodingIdMapper.isCollision(value)) {
                CollisionPoint existing;
                IdGroup group = this.groupOf(i);
                HashMap<Object, CollisionPoint> collisionsForGroup = (HashMap<Object, CollisionPoint>)collidedIds.get(group.id());
                if (collisionsForGroup == null) {
                    collisionsForGroup = new HashMap<Object, CollisionPoint>();
                    collidedIds.put(group.id(), collisionsForGroup);
                }
                if ((existing = (CollisionPoint)collisionsForGroup.get(id)) != null) {
                    throw new IllegalStateException("Id '" + id + "' is defined more than once in " + group.name() + ", at least at " + existing.sourceLocation + " and " + ids.toString());
                }
                collisionsForGroup.put(id, new CollisionPoint(i, ids.toString()));
                long val = this.encoder.encode(id);
                assert (val == EncodingIdMapper.clearCollision(value));
                int collisionIndex = this.collisionValues.size();
                this.collisionValues.add(id);
                this.collisionCache.set(collisionIndex, i);
            }
            ++i;
        }
    }

    private IdGroup groupOf(long dataIndex) {
        for (IdGroup idGroup : this.idGroups) {
            if (!idGroup.covers(dataIndex)) continue;
            return idGroup;
        }
        throw new IllegalArgumentException("Strange, index " + dataIndex + " isn't included in a group");
    }

    private long binarySearch(long x, Object inputId, long low, long high, PrimitiveIntPredicate inGroup) {
        while (low <= high) {
            long mid = low + (high - low) / 2L;
            int index = this.trackerCache.get(mid);
            if (index == -1) {
                return -1L;
            }
            long midValue = this.dataCache.get(index);
            if (Utils.unsignedCompare(EncodingIdMapper.clearCollision(midValue), x, Utils.CompareType.EQ)) {
                if (EncodingIdMapper.isCollision(midValue)) {
                    return this.findFromCollisions(mid, inputId, inGroup);
                }
                return inGroup.accept(this.groupOf(index).id()) ? (long)index : -1L;
            }
            if (Utils.unsignedCompare(EncodingIdMapper.clearCollision(midValue), x, Utils.CompareType.LT)) {
                low = mid + 1L;
                continue;
            }
            high = mid - 1L;
        }
        return -1L;
    }

    private long findIndex(LongArray array, long value) {
        long low = 0L;
        long high = this.size - 1L;
        while (low <= high) {
            long mid = (low + high) / 2L;
            long midValue = array.get(mid);
            if (Utils.unsignedCompare(midValue, value, Utils.CompareType.EQ)) {
                return mid;
            }
            if (Utils.unsignedCompare(midValue, value, Utils.CompareType.LT)) {
                low = mid + 1L;
                continue;
            }
            high = mid - 1L;
        }
        return -1L;
    }

    private long findFromCollisions(long index, Object inputId, PrimitiveIntPredicate inGroup) {
        long val = EncodingIdMapper.clearCollision(this.dataCache.get(this.trackerCache.get(index)));
        assert (val == this.encoder.encode(inputId));
        while (index > 0L && Utils.unsignedCompare(val, EncodingIdMapper.clearCollision(this.dataCache.get(this.trackerCache.get(index - 1L))), Utils.CompareType.EQ)) {
            --index;
        }
        long fromIndex = index;
        while (index < this.trackerCache.highestSetIndex() && Utils.unsignedCompare(val, EncodingIdMapper.clearCollision(this.dataCache.get(this.trackerCache.get(index + 1L))), Utils.CompareType.EQ)) {
            ++index;
        }
        long toIndex = index;
        long result = this.findFromCollisions(fromIndex, toIndex, inGroup, inputId, CollisionHandler.DETECTOR);
        if (result == -2L) {
            CollisionHandler.Detective detective = new CollisionHandler.Detective(inputId);
            this.findFromCollisions(fromIndex, toIndex, inGroup, inputId, detective);
            throw detective.exception();
        }
        return result;
    }

    private long findFromCollisions(long fromIndex, long toIndex, PrimitiveIntPredicate inGroup, Object inputId, CollisionHandler resolver) {
        long found = -1L;
        for (long index = fromIndex; index <= toIndex; ++index) {
            int collisionIndex;
            Object value;
            int dataIndex = this.trackerCache.get(index);
            IdGroup group = this.groupOf(dataIndex);
            if (!inGroup.accept(group.id()) || !inputId.equals(value = this.collisionValues.get(collisionIndex = Utils.safeCastLongToInt(this.findIndex(this.collisionCache, dataIndex))))) continue;
            long foundIndex = this.trackerCache.get(index);
            found = resolver.handle(found, foundIndex, group);
        }
        return found;
    }

    static boolean compareDataCache(LongArray dataCache, IntArray tracker, int a, int b, Utils.CompareType compareType) {
        int indexA = tracker.get(a);
        int indexB = tracker.get(b);
        if (indexA == -1 || indexB == -1) {
            return false;
        }
        return Utils.unsignedCompare(EncodingIdMapper.clearCollision(dataCache.get(indexA)), EncodingIdMapper.clearCollision(dataCache.get(indexB)), compareType);
    }

    @Override
    public void visitMemoryStats(MemoryStatsVisitor visitor) {
        this.dataCache.visit(visitor);
        this.trackerCache.visit(visitor);
        this.collisionCache.visit(visitor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.encoder + "," + this.radix + "]";
    }

    private static class CollisionPoint {
        private final long dataIndex;
        private final String sourceLocation;

        CollisionPoint(long dataIndex, String sourceLocation) {
            this.dataIndex = dataIndex;
            this.sourceLocation = sourceLocation;
        }
    }
}

