/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache.idmapping.string;

import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.IdGroup;

interface CollisionHandler {
    public static final long COLLISION_MARK = -2L;
    public static final CollisionHandler DETECTOR = new CollisionHandler(){

        @Override
        public long handle(long previousIndex, long foundIndex, IdGroup idGroup) {
            return previousIndex != -1L ? -2L : foundIndex;
        }
    };

    public long handle(long var1, long var3, IdGroup var5);

    public static class Detective
    implements CollisionHandler {
        private final Object inputId;
        private final StringBuilder error = new StringBuilder();

        public Detective(Object inputId) {
            this.inputId = inputId;
        }

        @Override
        public long handle(long previousIndex, long foundIndex, IdGroup idGroup) {
            this.error.append(String.format("%n  %s", idGroup));
            return foundIndex;
        }

        public IllegalStateException exception() {
            throw new IllegalStateException("Id '" + this.inputId + "' defined in multiple groups: " + this.error);
        }
    }
}

