/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapNumberArray;

public class OffHeapLongArray
extends OffHeapNumberArray
implements LongArray {
    private final long defaultValue;
    private long highestSetIndex = -1L;
    private long size;

    public OffHeapLongArray(long length, long defaultValue) {
        super(length, 3);
        this.defaultValue = defaultValue;
        this.clear();
    }

    @Override
    public long get(long index) {
        return unsafe.getLong(this.addressOf(index));
    }

    @Override
    public void set(long index, long value) {
        long address = this.addressOf(index);
        if (unsafe.getLong(address) == this.defaultValue) {
            ++this.size;
        }
        unsafe.putLong(address, value);
        if (index > this.highestSetIndex) {
            this.highestSetIndex = index;
        }
    }

    @Override
    public long highestSetIndex() {
        return this.highestSetIndex;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void clear() {
        if (this.isByteUniform(this.defaultValue)) {
            unsafe.setMemory(this.address, this.length << this.shift, (byte)this.defaultValue);
        } else {
            long i = 0L;
            long adr = this.address;
            while (i < this.length) {
                unsafe.putLong(adr, this.defaultValue);
                ++i;
                adr += (long)this.stride;
            }
        }
        this.highestSetIndex = -1L;
        this.size = 0L;
    }

    @Override
    public void swap(long fromIndex, long toIndex, int numberOfEntries) {
        long fromAddress = this.addressOf(fromIndex);
        long toAddress = this.addressOf(toIndex);
        int i = 0;
        while (i < numberOfEntries) {
            long fromValue = unsafe.getLong(fromAddress);
            unsafe.putLong(fromAddress, unsafe.getLong(toAddress));
            unsafe.putLong(toAddress, fromValue);
            ++i;
            fromAddress += (long)this.stride;
            toAddress += (long)this.stride;
        }
    }
}

