/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.StoreProcessor;
import org.neo4j.unsafe.impl.batchimport.StoreProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class RelationshipStoreProcessorStep
extends StoreProcessorStep<RelationshipRecord> {
    private final RelationshipStore relationshipStore;

    protected RelationshipStoreProcessorStep(StageControl control, String name, Configuration config, RelationshipStore relationshipStore, StoreProcessor<RelationshipRecord> processor) {
        super(control, name, config.batchSize(), config.movingAverageSize(), relationshipStore, processor);
        this.relationshipStore = relationshipStore;
    }

    @Override
    protected RelationshipRecord loadRecord(long id, RelationshipRecord into) {
        return this.relationshipStore.fillRecord(id, into, RecordLoad.CHECK) ? into : null;
    }

    @Override
    protected RelationshipRecord createReusableRecord() {
        return new RelationshipRecord(-1L);
    }
}

