/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.unsafe.impl.batchimport.StoreProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;

public class NodeCountsProcessor
implements StoreProcessor<NodeRecord> {
    private final NodeStore nodeStore;
    private final long[] labelCounts;
    private final NodeLabelsCache cache;
    private final CountsTracker countsTracker;
    private final int anyLabel;

    public NodeCountsProcessor(NodeStore nodeStore, NodeLabelsCache cache, int highLabelId, CountsTracker countsTracker) {
        this.nodeStore = nodeStore;
        this.cache = cache;
        this.anyLabel = highLabelId;
        this.countsTracker = countsTracker;
        this.labelCounts = new long[highLabelId + 1];
    }

    @Override
    public boolean process(NodeRecord node) {
        long[] labels = NodeLabelsField.get(node, this.nodeStore);
        if (labels.length > 0) {
            for (long labelId : labels) {
                int n = (int)labelId;
                this.labelCounts[n] = this.labelCounts[n] + 1L;
            }
            this.cache.put(node.getId(), labels);
        }
        int n = this.anyLabel;
        this.labelCounts[n] = this.labelCounts[n] + 1L;
        return false;
    }

    @Override
    public void done() {
        try (CountsAccessor.Updater updater = this.countsTracker.updater();){
            for (int i = 0; i < this.labelCounts.length; ++i) {
                updater.incrementNodeCount(i == this.anyLabel ? -1 : i, this.labelCounts[i]);
            }
        }
    }
}

