/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Collection;
import java.util.Iterator;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.AbstractRecordStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.Abstract64BitRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.transaction.state.PropertyCreator;
import org.neo4j.kernel.impl.util.ReusableIteratorCostume;
import org.neo4j.unsafe.impl.batchimport.Batch;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPageCache;
import org.neo4j.unsafe.impl.batchimport.store.BatchingPropertyRecordAccess;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class EntityStoreUpdaterStep<RECORD extends PrimitiveRecord, INPUT extends InputEntity>
extends ExecutorServiceStep<Batch<INPUT, RECORD>> {
    private final AbstractRecordStore<RECORD> entityStore;
    private final PropertyStore propertyStore;
    private final IoMonitor monitor;
    private final BatchingPageCache.WriterFactory writerFactory;
    private final PropertyCreator propertyCreator;
    private final BatchingPropertyRecordAccess propertyRecords = new BatchingPropertyRecordAccess();
    private final ReusableIteratorCostume<PropertyBlock> blockIterator = new ReusableIteratorCostume();

    EntityStoreUpdaterStep(StageControl control, Configuration config, AbstractRecordStore<RECORD> entityStore, PropertyStore propertyStore, IoMonitor monitor, BatchingPageCache.WriterFactory writerFactory) {
        super(control, "v", 1, config.movingAverageSize(), 1);
        this.entityStore = entityStore;
        this.propertyStore = propertyStore;
        this.writerFactory = writerFactory;
        this.propertyCreator = new PropertyCreator(propertyStore, null);
        this.monitor = monitor;
        this.monitor.reset();
    }

    @Override
    protected Object process(long ticket, Batch<INPUT, RECORD> batch) {
        this.propertyRecords.close();
        long highestId = 0L;
        RECORD[] records = batch.records;
        int propertyBlockCursor = 0;
        for (int i = 0; i < records.length; ++i) {
            Object record = records[i];
            InputEntity input = ((InputEntity[])batch.input)[i];
            if (input.hasFirstPropertyId()) {
                ((PrimitiveRecord)record).setNextProp(input.firstPropertyId());
            } else {
                int propertyBlockCount = batch.propertyBlocksLengths[i];
                if (propertyBlockCount > 0) {
                    this.reassignDynamicRecordIds(batch.propertyBlocks, propertyBlockCursor, propertyBlockCount);
                    long firstProp = this.propertyCreator.createPropertyChain((PrimitiveRecord)record, this.blockIterator.dressArray((PropertyBlock[])batch.propertyBlocks, propertyBlockCursor, propertyBlockCount), this.propertyRecords);
                    ((PrimitiveRecord)record).setNextProp(firstProp);
                    propertyBlockCursor += propertyBlockCount;
                }
            }
            highestId = Math.max(highestId, ((Abstract64BitRecord)record).getId());
            this.entityStore.updateRecord(record);
        }
        this.entityStore.setHighestPossibleIdInUse(highestId);
        for (PropertyRecord propertyRecord : this.propertyRecords.records()) {
            this.propertyStore.updateRecord(propertyRecord);
        }
        return null;
    }

    private void reassignDynamicRecordIds(PropertyBlock[] blocks, int offset, int length) {
        block4: for (int i = 0; i < length; ++i) {
            PropertyBlock block = blocks[offset + i];
            PropertyType type = block.getType();
            switch (type) {
                case STRING: {
                    this.reassignDynamicRecordIds(block, type, this.propertyStore.getStringStore());
                    continue block4;
                }
                case ARRAY: {
                    this.reassignDynamicRecordIds(block, type, this.propertyStore.getArrayStore());
                    continue block4;
                }
            }
        }
    }

    private void reassignDynamicRecordIds(PropertyBlock block, PropertyType type, AbstractDynamicStore store) {
        Iterator<DynamicRecord> dynamicRecords = block.getValueRecords().iterator();
        long newId = store.nextId();
        block.getValueBlocks()[0] = PropertyStore.singleBlockLongValue(block.getKeyIndexId(), type, newId);
        while (dynamicRecords.hasNext()) {
            DynamicRecord dynamicRecord = dynamicRecords.next();
            dynamicRecord.setId(newId);
            if (!dynamicRecords.hasNext()) continue;
            newId = store.nextId();
            dynamicRecord.setNextBlock(newId);
        }
    }

    @Override
    protected void addStatsProviders(Collection<StatsProvider> providers) {
        super.addStatsProviders(providers);
        providers.add(this.monitor);
    }

    @Override
    protected void done() {
        this.monitor.stop();
    }

    @Override
    public int numberOfProcessors() {
        return this.writerFactory.numberOfProcessors();
    }

    @Override
    public boolean incrementNumberOfProcessors() {
        return this.writerFactory.incrementNumberOfProcessors();
    }

    @Override
    public boolean decrementNumberOfProcessors() {
        return this.writerFactory.decrementNumberOfProcessors();
    }
}

