/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.function;

import org.neo4j.kernel.impl.util.function.Optional;

public class Optionals {
    public static final Optional NONE = new Optional(){

        public Object get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        public Optional or(Optional secondChoice) {
            return secondChoice;
        }

        public Optional or(Object secondChoice) {
            return Optionals.some(secondChoice);
        }
    };

    public static <TYPE> Optional<TYPE> none() {
        return NONE;
    }

    public static <TYPE> Optional<TYPE> some(final TYPE obj) {
        return new Optional<TYPE>(){

            @Override
            public TYPE get() {
                return obj;
            }

            @Override
            public boolean isPresent() {
                return true;
            }

            @Override
            public Optional<TYPE> or(Optional<TYPE> secondChoice) {
                return this;
            }

            @Override
            public Optional<TYPE> or(TYPE secondChoice) {
                return this;
            }
        };
    }

    public static abstract class LazyOptional<TYPE>
    implements Optional<TYPE> {
        private TYPE value;
        private boolean evaluated = false;

        protected abstract TYPE evaluate();

        @Override
        public TYPE get() {
            if (!this.isPresent()) {
                throw new UnsupportedOperationException();
            }
            return this.value();
        }

        @Override
        public boolean isPresent() {
            return this.value() != null;
        }

        @Override
        public Optional<TYPE> or(Optional<TYPE> secondChoice) {
            return this.isPresent() ? this : secondChoice;
        }

        @Override
        public Optional<TYPE> or(TYPE secondChoice) {
            return this.isPresent() ? this : Optionals.some(secondChoice);
        }

        private TYPE value() {
            if (!this.evaluated) {
                this.value = this.evaluate();
            }
            return this.value;
        }
    }
}

