/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.collection;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.function.Consumer;
import org.neo4j.function.Factory;
import org.neo4j.helpers.Clock;
import org.neo4j.kernel.impl.util.collection.ConcurrentAccessException;
import org.neo4j.kernel.impl.util.collection.NoSuchEntryException;

public class TimedRepository<KEY, VALUE>
implements Runnable {
    private final ConcurrentMap<KEY, Entry<VALUE>> repo = new ConcurrentHashMap<KEY, Entry<VALUE>>();
    private final Factory<VALUE> factory;
    private final Consumer<VALUE> reaper;
    private final long timeout;
    private final Clock clock;

    public TimedRepository(Factory<VALUE> provider, Consumer<VALUE> reaper, long timeout, Clock clock) {
        this.factory = provider;
        this.reaper = reaper;
        this.timeout = timeout;
        this.clock = clock;
    }

    public void begin(KEY key) throws ConcurrentAccessException {
        Object instance = this.factory.newInstance();
        if (this.repo.putIfAbsent(key, new Entry<Object>(instance)) != null) {
            this.reaper.accept(instance);
            throw new ConcurrentAccessException(String.format("Cannot begin '%s', because an entry with that key already exists.", key));
        }
    }

    public void end(KEY key) {
        Entry entry;
        do {
            if ((entry = (Entry)this.repo.get(key)) == null) {
                return;
            }
            if (entry.markForEndingIfInUse()) {
                return;
            }
            if (!entry.acquire()) continue;
            this.end0(key, entry.value);
            return;
        } while (!entry.isMarkedForEnding());
    }

    public VALUE acquire(KEY key) throws NoSuchEntryException, ConcurrentAccessException {
        Entry entry = (Entry)this.repo.get(key);
        if (entry == null) {
            throw new NoSuchEntryException(String.format("Cannot access '%s', no such entry exists.", key));
        }
        if (entry.acquire()) {
            return (VALUE)entry.value;
        }
        throw new ConcurrentAccessException(String.format("Cannot access '%s', because another client is currently using it.", key));
    }

    public void release(KEY key) {
        Entry entry = (Entry)this.repo.get(key);
        if (!entry.release()) {
            this.end0(key, entry.value);
        }
    }

    public Set<KEY> keys() {
        return this.repo.keySet();
    }

    @Override
    public void run() {
        long maxAllowedAge = this.clock.currentTimeMillis() - this.timeout;
        for (KEY key : this.keys()) {
            Entry entry = (Entry)this.repo.get(key);
            if (entry == null || entry.latestActivityTimestamp >= maxAllowedAge || !entry.acquire() || entry.latestActivityTimestamp >= maxAllowedAge) continue;
            this.end0(key, entry.value);
        }
    }

    private void end0(KEY key, VALUE value) {
        this.repo.remove(key);
        this.reaper.accept(value);
    }

    private class Entry<VALUE> {
        static final int IDLE = 0;
        static final int IN_USE = 1;
        static final int MARKED_FOR_END = 2;
        private final AtomicInteger state = new AtomicInteger(0);
        private final VALUE value;
        private volatile long latestActivityTimestamp;

        public Entry(VALUE value) {
            this.value = value;
            this.latestActivityTimestamp = TimedRepository.this.clock.currentTimeMillis();
        }

        public boolean acquire() {
            return this.state.compareAndSet(0, 1);
        }

        public boolean release() {
            this.latestActivityTimestamp = TimedRepository.this.clock.currentTimeMillis();
            return this.state.compareAndSet(1, 0);
        }

        public boolean markForEndingIfInUse() {
            return this.state.compareAndSet(1, 2);
        }

        public boolean isMarkedForEnding() {
            return this.state.get() == 2;
        }
    }
}

