/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;

public class PhysicalWritableLogChannel
implements WritableLogChannel {
    private LogVersionedStoreChannel channel;
    private final ByteBuffer buffer = ByteBuffer.allocate(512 * Format.KB);

    public PhysicalWritableLogChannel(LogVersionedStoreChannel channel) {
        this.channel = channel;
    }

    @Override
    public void force() throws IOException {
        this.channel.force(false);
    }

    void setChannel(LogVersionedStoreChannel channel) {
        this.channel = channel;
    }

    @Override
    public void emptyBufferIntoChannelAndClearIt() throws IOException {
        this.buffer.flip();
        this.channel.write(this.buffer);
        this.buffer.clear();
    }

    @Override
    public WritableLogChannel put(byte value) throws IOException {
        this.bufferWithGuaranteedSpace(1).put(value);
        return this;
    }

    @Override
    public WritableLogChannel putShort(short value) throws IOException {
        this.bufferWithGuaranteedSpace(2).putShort(value);
        return this;
    }

    @Override
    public WritableLogChannel putInt(int value) throws IOException {
        this.bufferWithGuaranteedSpace(4).putInt(value);
        return this;
    }

    @Override
    public WritableLogChannel putLong(long value) throws IOException {
        this.bufferWithGuaranteedSpace(8).putLong(value);
        return this;
    }

    @Override
    public WritableLogChannel putFloat(float value) throws IOException {
        this.bufferWithGuaranteedSpace(4).putFloat(value);
        return this;
    }

    @Override
    public WritableLogChannel putDouble(double value) throws IOException {
        this.bufferWithGuaranteedSpace(8).putDouble(value);
        return this;
    }

    @Override
    public WritableLogChannel put(byte[] value, int length) throws IOException {
        int chunkSize;
        for (int offset = 0; offset < length; offset += chunkSize) {
            chunkSize = Math.min(length - offset, this.buffer.capacity() >> 1);
            this.bufferWithGuaranteedSpace(chunkSize).put(value, offset, chunkSize);
        }
        return this;
    }

    @Override
    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(this.channel.getVersion(), this.channel.position() + (long)this.buffer.position());
        return positionMarker;
    }

    private ByteBuffer bufferWithGuaranteedSpace(int spaceInBytes) throws IOException {
        assert (spaceInBytes < this.buffer.capacity());
        if (this.buffer.remaining() < spaceInBytes) {
            this.emptyBufferIntoChannelAndClearIt();
        }
        return this.buffer;
    }

    @Override
    public void close() throws IOException {
        this.emptyBufferIntoChannelAndClearIt();
    }
}

