/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ReadPastEndException;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;

public class InMemoryLogChannel
implements WritableLogChannel,
ReadableLogChannel {
    private final byte[] bytes = new byte[1000];
    private final ByteBuffer asWriter = ByteBuffer.wrap(this.bytes);
    private final ByteBuffer asReader = ByteBuffer.wrap(this.bytes);

    public void reset() {
        this.asWriter.clear();
        this.asReader.clear();
        Arrays.fill(this.bytes, (byte)0);
    }

    @Override
    public InMemoryLogChannel put(byte b) throws IOException {
        this.asWriter.put(b);
        return this;
    }

    @Override
    public InMemoryLogChannel putShort(short s) throws IOException {
        this.asWriter.putShort(s);
        return this;
    }

    @Override
    public InMemoryLogChannel putInt(int i) throws IOException {
        this.asWriter.putInt(i);
        return this;
    }

    @Override
    public InMemoryLogChannel putLong(long l) throws IOException {
        this.asWriter.putLong(l);
        return this;
    }

    @Override
    public InMemoryLogChannel putFloat(float f) throws IOException {
        this.asWriter.putFloat(f);
        return this;
    }

    @Override
    public InMemoryLogChannel putDouble(double d) throws IOException {
        this.asWriter.putDouble(d);
        return this;
    }

    @Override
    public InMemoryLogChannel put(byte[] bytes, int length) throws IOException {
        this.asWriter.put(bytes, 0, length);
        return this;
    }

    @Override
    public void force() throws IOException {
    }

    public StoreChannel getFileChannel() {
        throw new UnsupportedOperationException();
    }

    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void emptyBufferIntoChannelAndClearIt() {
    }

    @Override
    public byte get() throws ReadPastEndException {
        this.ensureAvailableToRead(1);
        return this.asReader.get();
    }

    @Override
    public short getShort() throws ReadPastEndException {
        this.ensureAvailableToRead(2);
        return this.asReader.getShort();
    }

    @Override
    public int getInt() throws ReadPastEndException {
        this.ensureAvailableToRead(4);
        return this.asReader.getInt();
    }

    @Override
    public long getLong() throws ReadPastEndException {
        this.ensureAvailableToRead(8);
        return this.asReader.getLong();
    }

    @Override
    public float getFloat() throws ReadPastEndException {
        this.ensureAvailableToRead(4);
        return this.asReader.getFloat();
    }

    @Override
    public double getDouble() throws ReadPastEndException {
        this.ensureAvailableToRead(8);
        return this.asReader.getDouble();
    }

    @Override
    public void get(byte[] bytes, int length) throws ReadPastEndException {
        this.ensureAvailableToRead(length);
        this.asReader.get(bytes, 0, length);
    }

    private void ensureAvailableToRead(int i) throws ReadPastEndException {
        if (this.asReader.remaining() < i) {
            throw ReadPastEndException.INSTANCE;
        }
    }

    @Override
    public LogPositionMarker getCurrentPosition(LogPositionMarker positionMarker) {
        positionMarker.mark(0L, this.asWriter.position());
        return positionMarker;
    }

    public int positionWriter(int position) {
        int previous = this.asWriter.position();
        this.asWriter.position(position);
        return previous;
    }

    public int positionReader(int position) {
        int previous = this.asReader.position();
        this.asReader.position(position);
        return previous;
    }

    public int readerPosition() {
        return this.asReader.position();
    }

    public int writerPosition() {
        return this.asWriter.position();
    }

    public void truncateTo(int bytesSuccessfullyWritten) {
        this.asReader.limit(bytesSuccessfullyWritten);
    }

    public int capacity() {
        return this.bytes.length;
    }

    public int availableBytesToRead() {
        return this.asReader.remaining();
    }

    public int availableBytesToWrite() {
        return this.asWriter.remaining();
    }
}

