/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.helpers.UTF8;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;

public final class SortedKeyValueStoreHeader {
    public static final long BASE_MINOR_VERSION = 1L;
    public static final int META_HEADER_SIZE = 24;
    private final int recordSize;
    private final byte[] storeFormatVersion;
    private final int dataRecords;
    private final long lastTxId;
    private final long minorVersion;

    public static SortedKeyValueStoreHeader with(int recordSize, String storeFormatVersion, long lastTxId, long minorVersion) {
        if (storeFormatVersion == null) {
            throw new IllegalArgumentException("store format version cannot be null");
        }
        byte[] version = UTF8.encode(storeFormatVersion);
        return new SortedKeyValueStoreHeader(recordSize, version, 0, lastTxId, minorVersion);
    }

    private SortedKeyValueStoreHeader(int recordSize, byte[] storeFormatVersion, int dataRecords, long lastTxId, long minorVersion) {
        this.recordSize = recordSize;
        this.storeFormatVersion = storeFormatVersion;
        this.dataRecords = dataRecords;
        this.lastTxId = lastTxId;
        this.minorVersion = minorVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortedKeyValueStoreHeader that = (SortedKeyValueStoreHeader)o;
        return this.dataRecords == that.dataRecords && this.lastTxId == that.lastTxId && this.minorVersion == that.minorVersion && Arrays.equals(this.storeFormatVersion, that.storeFormatVersion);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.storeFormatVersion);
        result = 31 * result + this.dataRecords;
        result = 31 * result + (int)(this.lastTxId ^ this.lastTxId >>> 32);
        result = 31 * result + (int)(this.minorVersion ^ this.minorVersion >>> 32);
        return result;
    }

    public String toString() {
        return String.format("%s[storeFormatVersion=%s, dataRecords=%d, lastTxId=%d, minorVersion=%d]", this.getClass().getSimpleName(), this.storeFormatVersion(), this.dataRecords, this.lastTxId, this.minorVersion);
    }

    public SortedKeyValueStoreHeader update(int dataRecords, long lastTxId, long minorVersion) {
        return new SortedKeyValueStoreHeader(this.recordSize, this.storeFormatVersion, dataRecords, lastTxId, minorVersion);
    }

    String storeFormatVersion() {
        return UTF8.decode(this.storeFormatVersion);
    }

    public int headerRecords() {
        int headerBytes = 24 + this.storeFormatVersion.length;
        headerBytes += this.recordSize - headerBytes % this.recordSize;
        return headerBytes / this.recordSize;
    }

    public int dataRecords() {
        return this.dataRecords;
    }

    public long lastTxId() {
        return this.lastTxId;
    }

    public long minorVersion() {
        return this.minorVersion;
    }

    public static SortedKeyValueStoreHeader read(int recordSize, PagedFile pagedFile) throws IOException {
        Throwable throwable = null;
        try (PageCursor page = pagedFile.io(0L, 1);){
            if (page.next()) {
                long minorVersion;
                long lastTxId;
                int dataRecords;
                short versionLength;
                byte[] storeFormatVersion = null;
                int versionSpace = -1;
                byte[] tail = null;
                do {
                    page.setOffset(0);
                    short headerRecords = page.getShort();
                    versionLength = page.getShort();
                    dataRecords = page.getInt();
                    lastTxId = page.getLong();
                    minorVersion = page.getLong();
                    if (versionLength < 0) continue;
                    storeFormatVersion = new byte[versionLength];
                    page.getBytes(storeFormatVersion);
                    versionSpace = headerRecords * recordSize - 24;
                    int tailLength = versionSpace - versionLength - 1;
                    if (tailLength < 0) continue;
                    tail = new byte[tailLength];
                    page.getBytes(tail);
                } while (page.shouldRetry());
                SortedKeyValueStoreHeader.checkConsistentHeader(recordSize, versionLength, versionSpace);
                SortedKeyValueStoreHeader.checkZeroPadded(tail);
                SortedKeyValueStoreHeader sortedKeyValueStoreHeader = new SortedKeyValueStoreHeader(recordSize, storeFormatVersion, dataRecords, lastTxId, minorVersion);
                return sortedKeyValueStoreHeader;
            }
            try {
                throw new IOException("Could not read count store header page");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static void checkConsistentHeader(int recordSize, short versionLength, int versionSpace) throws IOException {
        if (versionLength < 0 && versionLength > versionSpace || versionLength < versionSpace - recordSize) {
            throw new IOException(String.format("Invalid header data, versionLength=%d, versionSpace=%d.", versionLength, versionSpace));
        }
    }

    private static void checkZeroPadded(byte[] tail) throws IOException {
        if (tail == null) {
            throw new IOException("Unexpected header data.");
        }
        for (int i = 0; i < tail.length; ++i) {
            if (tail[i] == 0) continue;
            throw new IOException("Unexpected header data.");
        }
    }

    public void write(PagedFile pagedFile) throws IOException {
        block13: {
            try (PageCursor page = pagedFile.io(0L, 2);){
                if (page.next()) {
                    this.write(page);
                    break block13;
                }
                throw new IOException("Could not write count store header page");
            }
        }
    }

    public void write(PageCursor page) throws IOException {
        do {
            page.setOffset(0);
            page.putShort((short)this.headerRecords());
            page.putShort((short)this.storeFormatVersion.length);
            page.putInt(this.dataRecords);
            page.putLong(this.lastTxId);
            page.putLong(this.minorVersion);
            page.putBytes(this.storeFormatVersion);
            page.setOffset(this.recordSize * this.headerRecords());
        } while (page.shouldRetry());
    }
}

