/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveFormat;
import org.neo4j.kernel.impl.store.kvstore.RotationStrategy;

@Inherited
@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface Rotation {
    public Strategy value();

    public String[] parameters() default {".a", ".b"};

    public static enum Strategy {
        LEFT_RIGHT{

            @Override
            <Meta> RotationStrategy<Meta> create(FileSystemAbstraction fs, PageCache pages, ProgressiveFormat<Meta> format, File base, String[] parameters) {
                if (parameters == null || parameters.length != 2) {
                    throw new IllegalArgumentException("Expected exactly 2 format parameters.");
                }
                String parent = base.getParent();
                String l = base.getName() + parameters[0];
                String r = base.getName() + parameters[1];
                File left = new File(parent, l);
                File right = new File(parent, r);
                return new RotationStrategy.LeftRight<Meta>(fs, pages, format, left, right);
            }
        }
        ,
        INCREMENTING{

            @Override
            <Meta> RotationStrategy<Meta> create(FileSystemAbstraction fs, PageCache pages, ProgressiveFormat<Meta> format, File base, String[] parameters) {
                return new RotationStrategy.Incrementing<Meta>(fs, pages, format, base);
            }
        };


        abstract <Meta> RotationStrategy<Meta> create(FileSystemAbstraction var1, PageCache var2, ProgressiveFormat<Meta> var3, File var4, String ... var5);
    }
}

