/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.kvstore;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.locking.LockWrapper;
import org.neo4j.kernel.impl.store.kvstore.BigEndianByteArrayBuffer;
import org.neo4j.kernel.impl.store.kvstore.CollectedMetadata;
import org.neo4j.kernel.impl.store.kvstore.DataProvider;
import org.neo4j.kernel.impl.store.kvstore.EntryVisitor;
import org.neo4j.kernel.impl.store.kvstore.HeaderField;
import org.neo4j.kernel.impl.store.kvstore.KeyFormat;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreFile;
import org.neo4j.kernel.impl.store.kvstore.KeyValueStoreState;
import org.neo4j.kernel.impl.store.kvstore.KeyValueVisitor;
import org.neo4j.kernel.impl.store.kvstore.MetadataVisitor;
import org.neo4j.kernel.impl.store.kvstore.ProgressiveFormat;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.Rotation;
import org.neo4j.kernel.impl.store.kvstore.State;
import org.neo4j.kernel.impl.store.kvstore.UnknownKey;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

@Rotation(value=Rotation.Strategy.LEFT_RIGHT)
@State(value=State.Strategy.CONCURRENT_HASH_MAP)
public abstract class AbstractKeyValueStore<Key, MetaData, MetaDiff>
extends LifecycleAdapter {
    private final ReadWriteLock updateLock = new ReentrantReadWriteLock(true);
    private volatile KeyValueStoreState<Key, MetaData> state;
    final int keySize;
    final int valueSize;

    public AbstractKeyValueStore(FileSystemAbstraction fs, PageCache pages, File base, int keySize, int valueSize, HeaderField<MetaData, ?> ... headerFields) {
        this.keySize = keySize;
        this.valueSize = valueSize;
        Rotation rotation = this.getClass().getAnnotation(Rotation.class);
        Format format = new Format(headerFields);
        this.state = this.getClass().getAnnotation(State.class).value().initialState(rotation.value().create(fs, pages, format, base, rotation.parameters()), format);
    }

    public String toString() {
        return String.format("%s[state=%s, hasChanges=%s]", this.getClass().getSimpleName(), this.state, this.state.hasChanges());
    }

    protected final <Value> Value lookup(Key key, Reader<Value> lookup) throws IOException {
        return this.state.lookup(key, lookup);
    }

    protected final void visitAll(Visitor visitor) throws IOException {
        KeyValueStoreState<Key, MetaData> state = this.state;
        if (visitor instanceof MetadataVisitor) {
            MetadataVisitor metadataVisitor = (MetadataVisitor)((Object)visitor);
            metadataVisitor.visitMetadata(state.file(), this.metadata(), state.totalRecordsStored());
        }
        try (DataProvider provider = state.dataProvider();){
            this.transfer(provider, visitor);
        }
    }

    protected final void visitFile(File path, Visitor visitor) throws IOException {
        try (KeyValueStoreFile<MetaData> file = this.state.openStoreFile(path);){
            if (visitor instanceof MetadataVisitor) {
                MetadataVisitor metadataVisitor = (MetadataVisitor)((Object)visitor);
                metadataVisitor.visitMetadata(path, file.metadata(), file.recordCount());
            }
            try (DataProvider provider = file.dataProvider();){
                this.transfer(provider, visitor);
            }
        }
    }

    protected abstract Key readKey(ReadableBuffer var1) throws UnknownKey;

    protected abstract void writeKey(Key var1, WritableBuffer var2);

    protected abstract void writeFormatSpecifier(WritableBuffer var1);

    protected abstract MetaData initialMetadata();

    protected abstract int compareMetadata(MetaData var1, MetaData var2);

    protected boolean hasMetadataChanges(MetaData metadata, MetaDiff diff) {
        return true;
    }

    protected abstract MetaData buildMetadata(ReadableBuffer var1, CollectedMetadata var2);

    protected abstract MetaData updateMetadata(MetaData var1, MetaDiff var2);

    protected abstract String extractFileTrailer(MetaData var1);

    protected boolean include(Key key, ReadableBuffer value) {
        return true;
    }

    protected final MetaData metadata() {
        return this.state.metadata();
    }

    public int totalRecordsStored() {
        return this.state.totalRecordsStored();
    }

    public final File currentFile() {
        return this.state.file();
    }

    @Override
    public final void init() throws IOException {
        try (LockWrapper ignored = LockWrapper.writeLock(this.updateLock);){
            this.state = this.state.init();
        }
    }

    @Override
    public final void start() throws IOException {
        try (LockWrapper ignored = LockWrapper.writeLock(this.updateLock);){
            this.state = this.state.start();
        }
    }

    protected final void apply(Update<Key> update) throws IOException {
        try (LockWrapper ignored = LockWrapper.readLock(this.updateLock);){
            this.state.apply(update);
        }
    }

    protected void failedToOpenStoreFile(File path, Exception error) {
    }

    protected void rotationFailed(File source, File target, MetaData metaData, Exception e) {
    }

    protected void rotationSucceeded(File source, File target, MetaData metaData) {
    }

    protected void beforeRotation(File source, File target, MetaData metaData) {
    }

    protected final void rotate(MetaDiff metadataChanges) throws IOException {
        try (LockWrapper ignored = LockWrapper.writeLock(this.updateLock);){
            KeyValueStoreState<Key, MetaData> current = this.state;
            if (!current.hasChanges() && !this.hasMetadataChanges(current.metadata(), metadataChanges)) {
                return;
            }
            this.state = this.state.rotate(this.updateMetadata(current.metadata(), metadataChanges));
        }
    }

    @Override
    public final void shutdown() throws IOException {
        this.state = this.state.shutdown();
    }

    private boolean transfer(EntryVisitor<WritableBuffer> producer, EntryVisitor<ReadableBuffer> consumer) throws IOException {
        BigEndianByteArrayBuffer key = new BigEndianByteArrayBuffer(this.keySize);
        BigEndianByteArrayBuffer value = new BigEndianByteArrayBuffer(this.valueSize);
        while (producer.visit(key, value)) {
            if (consumer.visit(key, value)) continue;
            return false;
        }
        return true;
    }

    private final class Format
    extends ProgressiveFormat<MetaData>
    implements KeyFormat<Key> {
        Format(HeaderField<MetaData, ?> ... headerFields) {
            super(512, (HeaderField<Meta, ?>[])headerFields);
        }

        @Override
        protected void writeFormatSpecifier(WritableBuffer formatSpecifier) {
            AbstractKeyValueStore.this.writeFormatSpecifier(formatSpecifier);
        }

        @Override
        protected String extractFileTrailer(MetaData metadata) {
            return AbstractKeyValueStore.this.extractFileTrailer(metadata);
        }

        @Override
        protected MetaData buildMetadata(ReadableBuffer formatSpecifier, CollectedMetadata metadata) {
            return AbstractKeyValueStore.this.buildMetadata(formatSpecifier, metadata);
        }

        @Override
        public void writeKey(Key key, WritableBuffer buffer) {
            AbstractKeyValueStore.this.writeKey(key, buffer);
        }

        @Override
        public int compareMetadata(MetaData lhs, MetaData rhs) {
            return AbstractKeyValueStore.this.compareMetadata(lhs, rhs);
        }

        @Override
        public MetaData initialMetadata() {
            return AbstractKeyValueStore.this.initialMetadata();
        }

        @Override
        public int keySize() {
            return AbstractKeyValueStore.this.keySize;
        }

        @Override
        public DataProvider filter(final DataProvider provider) {
            return new DataProvider(){

                @Override
                public boolean visit(WritableBuffer key, WritableBuffer value) throws IOException {
                    while (provider.visit(key, value)) {
                        try {
                            if (!AbstractKeyValueStore.this.include(AbstractKeyValueStore.this.readKey(key), value)) continue;
                            return true;
                        }
                        catch (UnknownKey e) {
                            throw new IllegalArgumentException(e.getMessage(), e);
                        }
                    }
                    return false;
                }

                @Override
                public void close() throws IOException {
                    provider.close();
                }
            };
        }

        @Override
        public int valueSize() {
            return AbstractKeyValueStore.this.valueSize;
        }

        @Override
        public void failedToOpenStoreFile(File path, Exception error) {
            AbstractKeyValueStore.this.failedToOpenStoreFile(path, error);
        }

        @Override
        public void beforeRotation(File source, File target, MetaData metaData) {
            AbstractKeyValueStore.this.beforeRotation(source, target, metaData);
        }

        @Override
        public void rotationSucceeded(File source, File target, MetaData metaData) {
            AbstractKeyValueStore.this.rotationSucceeded(source, target, metaData);
        }

        @Override
        public void rotationFailed(File source, File target, MetaData metaData, Exception e) {
            AbstractKeyValueStore.this.rotationFailed(source, target, metaData, e);
        }
    }

    public abstract class Visitor
    implements KeyValueVisitor {
        @Override
        public boolean visit(ReadableBuffer key, ReadableBuffer value) {
            try {
                return this.visitKeyValuePair(AbstractKeyValueStore.this.readKey(key), value);
            }
            catch (UnknownKey e) {
                return this.visitUnknownKey(e, key, value);
            }
        }

        protected boolean visitUnknownKey(UnknownKey exception, ReadableBuffer key, ReadableBuffer value) {
            throw new IllegalArgumentException(exception.getMessage(), exception);
        }

        protected abstract boolean visitKeyValuePair(Key var1, ReadableBuffer var2);
    }

    public static abstract class Reader<Value> {
        protected abstract Value parseValue(ReadableBuffer var1);

        protected Value defaultValue() {
            return null;
        }
    }

    public static abstract class Update<Key> {
        final Key key;

        public Update(Key key) {
            this.key = key;
        }

        protected abstract void update(WritableBuffer var1);
    }

    protected abstract class Updater
    implements AutoCloseable {
        private final KeyValueStoreState<Key, MetaData> state;
        private Thread thread = Thread.currentThread();

        public Updater() {
            AbstractKeyValueStore.this.updateLock.readLock().lock();
            this.state = AbstractKeyValueStore.this.state;
        }

        protected final void apply(Update<Key> update) throws IOException {
            if (this.thread != Thread.currentThread()) {
                throw new IllegalStateException("Updater of " + AbstractKeyValueStore.this + " is not available.");
            }
            this.state.apply(update);
        }

        @Override
        public final void close() {
            this.thread = null;
            AbstractKeyValueStore.this.updateLock.readLock().unlock();
        }
    }
}

