/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import org.neo4j.kernel.impl.store.kvstore.HeaderField;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;

final class Metadata {
    static final HeaderField<Metadata, TxId> TX_ID = new HeaderField<Metadata, TxId>(){

        @Override
        public TxId read(ReadableBuffer header) {
            return new TxId(header.getLong(0), header.getLong(8));
        }

        @Override
        public void write(Metadata headers, WritableBuffer header) {
            header.putLong(0, headers.txId);
            header.putLong(8, headers.minorVersion);
        }

        public String toString() {
            return "<Transaction ID>";
        }
    };
    static final HeaderField<Metadata, ?>[] KEYS = new HeaderField[]{TX_ID};
    final long txId;
    final long minorVersion;

    Metadata(long txId, long minorVersion) {
        this.txId = txId;
        this.minorVersion = minorVersion;
    }

    Metadata update(Diff changes) {
        return new Metadata(changes.txId, this.txId == changes.txId ? this.minorVersion + 1L : 1L);
    }

    static final class TxId {
        final long txId;
        final long minorVersion;

        TxId(long txId, long minorVersion) {
            this.txId = txId;
            this.minorVersion = minorVersion;
        }
    }

    static class Diff {
        final long txId;

        Diff(long txId) {
            this.txId = txId;
        }
    }
}

