/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.File;
import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.counts.AssignValues;
import org.neo4j.kernel.impl.store.counts.Metadata;
import org.neo4j.kernel.impl.store.counts.UpdateFirstValue;
import org.neo4j.kernel.impl.store.counts.UpdateSecondValue;
import org.neo4j.kernel.impl.store.counts.ValueRegister;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.kvstore.AbstractKeyValueStore;
import org.neo4j.kernel.impl.store.kvstore.CollectedMetadata;
import org.neo4j.kernel.impl.store.kvstore.MetadataVisitor;
import org.neo4j.kernel.impl.store.kvstore.ReadableBuffer;
import org.neo4j.kernel.impl.store.kvstore.Rotation;
import org.neo4j.kernel.impl.store.kvstore.UnknownKey;
import org.neo4j.kernel.impl.store.kvstore.WritableBuffer;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.register.Register;

@Rotation(value=Rotation.Strategy.LEFT_RIGHT, parameters={".a", ".b"})
public class CountsTracker
extends AbstractKeyValueStore<CountsKey, Metadata, Metadata.Diff>
implements CountsVisitor.Visitable,
CountsAccessor {
    private static final byte[] FORMAT = new byte[]{78, 101, 111, 67, 111, 117, 110, 116, 83, 116, 111, 114, 101, 0, 0, 86};
    public static final String LEFT = ".a";
    public static final String RIGHT = ".b";
    public static final String TYPE_DESCRIPTOR = "CountsStore";
    private final StringLogger logger;

    public CountsTracker(StringLogger logger, FileSystemAbstraction fs, PageCache pages, File baseFile) {
        super(fs, pages, baseFile, 16, 16, Metadata.KEYS);
        this.logger = logger;
    }

    @Override
    public void rotate(long txId) throws IOException {
        this.logger.debug("Start writing new counts store with txId=" + txId);
        this.rotate(new Metadata.Diff(txId));
        this.logger.debug("Completed writing of counts store with txId=" + txId);
    }

    public boolean acceptTx(long txId) {
        Metadata metadata = (Metadata)this.metadata();
        return metadata != null && metadata.txId < txId;
    }

    public long txId() {
        return ((Metadata)this.metadata()).txId;
    }

    public long minorVersion() {
        return ((Metadata)this.metadata()).minorVersion;
    }

    public Register.DoubleLongRegister get(CountsKey key, Register.DoubleLongRegister target) {
        try {
            return this.lookup(key, new ValueRegister(target));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public Register.DoubleLongRegister nodeCount(int labelId, Register.DoubleLongRegister target) {
        return this.get(CountsKeyFactory.nodeKey(labelId), target);
    }

    @Override
    public Register.DoubleLongRegister relationshipCount(int startLabelId, int typeId, int endLabelId, Register.DoubleLongRegister target) {
        return this.get(CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId), target);
    }

    @Override
    public Register.DoubleLongRegister indexUpdatesAndSize(int labelId, int propertyKeyId, Register.DoubleLongRegister target) {
        return this.get(CountsKeyFactory.indexStatisticsKey(labelId, propertyKeyId), target);
    }

    @Override
    public Register.DoubleLongRegister indexSample(int labelId, int propertyKeyId, Register.DoubleLongRegister target) {
        return this.get(CountsKeyFactory.indexSampleKey(labelId, propertyKeyId), target);
    }

    @Override
    public void incrementIndexUpdates(int labelId, int propertyKeyId, long delta) {
        try {
            this.apply(new UpdateFirstValue(CountsKeyFactory.indexStatisticsKey(labelId, propertyKeyId), delta));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public CountsAccessor.Updater updater() {
        return new ValueFormat();
    }

    @Override
    public void accept(CountsVisitor visitor) {
        try {
            this.visitAll(new DelegatingVisitor(visitor));
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    void visitFile(File path, CountsVisitor visitor) throws IOException {
        super.visitFile(path, new DelegatingVisitor(visitor));
    }

    @Override
    protected Metadata initialMetadata() {
        return new Metadata(-1L, 1L);
    }

    @Override
    protected int compareMetadata(Metadata lhs, Metadata rhs) {
        return CountsTracker.compare(lhs, rhs);
    }

    static int compare(Metadata lhs, Metadata rhs) {
        int cmp = Long.compare(lhs.txId, rhs.txId);
        if (cmp == 0) {
            cmp = Long.compare(lhs.minorVersion, rhs.minorVersion);
        }
        return cmp;
    }

    @Override
    protected Metadata updateMetadata(Metadata metadata, Metadata.Diff changes) {
        return metadata.update(changes);
    }

    @Override
    protected void writeKey(CountsKey key, WritableBuffer buffer) {
        key.accept(new KeyFormat(buffer), 0L, 0L);
    }

    @Override
    protected CountsKey readKey(ReadableBuffer key) throws UnknownKey {
        switch (key.getByte(0)) {
            case 1: {
                return CountsKeyFactory.nodeKey(key.getInt(12));
            }
            case 2: {
                return CountsKeyFactory.relationshipKey(key.getInt(4), key.getInt(8), key.getInt(12));
            }
            case 127: {
                switch (key.getByte(15)) {
                    case 1: {
                        return CountsKeyFactory.indexStatisticsKey(key.getInt(4), key.getInt(8));
                    }
                    case 2: {
                        return CountsKeyFactory.indexSampleKey(key.getInt(4), key.getInt(8));
                    }
                }
            }
        }
        throw new UnknownKey("Unknown key type: " + key);
    }

    @Override
    protected Metadata buildMetadata(ReadableBuffer formatSpecifier, CollectedMetadata metadata) {
        Metadata.TxId txId = metadata.getMetadata(Metadata.TX_ID);
        return new Metadata(txId.txId, txId.minorVersion);
    }

    @Override
    protected String extractFileTrailer(Metadata metadata) {
        return StoreFactory.buildTypeDescriptorAndVersion(TYPE_DESCRIPTOR);
    }

    @Override
    protected boolean include(CountsKey countsKey, ReadableBuffer value) {
        return !value.allZeroes();
    }

    @Override
    protected void failedToOpenStoreFile(File path, Exception error) {
        this.logger.logMessage("Failed to open counts store file: " + path, error);
    }

    @Override
    protected void beforeRotation(File source, File target, Metadata metadata) {
        this.logger.logMessage(String.format("About to rotate counts store at transaction %d to [%s], from [%s].", metadata.txId, target, source));
    }

    @Override
    protected void rotationSucceeded(File source, File target, Metadata metadata) {
        this.logger.logMessage(String.format("Successfully rotated counts store at transaction %d to [%s], from [%s].", metadata.txId, target, source));
    }

    @Override
    protected void rotationFailed(File source, File target, Metadata metadata, Exception e) {
        this.logger.logMessage(String.format("Failed to rotate counts store at transaction %d to [%s], from [%s].", metadata.txId, target, source), e);
    }

    @Override
    protected void writeFormatSpecifier(WritableBuffer formatSpecifier) {
        formatSpecifier.put(0, FORMAT);
    }

    @Override
    protected boolean hasMetadataChanges(Metadata metadata, Metadata.Diff diff) {
        return metadata != null && metadata.txId != diff.txId;
    }

    private class ValueFormat
    extends AbstractKeyValueStore.Updater
    implements CountsAccessor.Updater {
        private ValueFormat() {
            super(CountsTracker.this);
        }

        @Override
        public void incrementNodeCount(int labelId, long delta) {
            try {
                this.apply(new UpdateSecondValue(CountsKeyFactory.nodeKey(labelId), delta));
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }

        @Override
        public void incrementRelationshipCount(int startLabelId, int typeId, int endLabelId, long delta) {
            try {
                this.apply(new UpdateSecondValue(CountsKeyFactory.relationshipKey(startLabelId, typeId, endLabelId), delta));
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }

        @Override
        public void replaceIndexUpdateAndSize(int labelId, int propertyKeyId, long updates, long size) {
            try {
                this.apply(new AssignValues(CountsKeyFactory.indexStatisticsKey(labelId, propertyKeyId), updates, size));
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }

        @Override
        public void replaceIndexSample(int labelId, int propertyKeyId, long unique, long size) {
            try {
                this.apply(new AssignValues(CountsKeyFactory.indexSampleKey(labelId, propertyKeyId), unique, size));
            }
            catch (IOException e) {
                throw new UnderlyingStorageException(e);
            }
        }
    }

    private static class KeyFormat
    implements CountsVisitor {
        private static final byte NODE_COUNT = 1;
        private static final byte RELATIONSHIP_COUNT = 2;
        private static final byte INDEX = 127;
        private static final byte INDEX_STATS = 1;
        private static final byte INDEX_SAMPLE = 2;
        private final WritableBuffer buffer;

        public KeyFormat(WritableBuffer key) {
            assert (key.size() >= 16);
            this.buffer = key;
        }

        @Override
        public void visitNodeCount(int labelId, long count) {
            this.buffer.putByte(0, (byte)1).putInt(12, labelId);
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
            this.buffer.putByte(0, (byte)2).putInt(4, startLabelId).putInt(8, typeId).putInt(12, endLabelId);
        }

        @Override
        public void visitIndexStatistics(int labelId, int propertyKeyId, long updates, long size) {
            this.indexKey((byte)1, labelId, propertyKeyId);
        }

        @Override
        public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size) {
            this.indexKey((byte)2, labelId, propertyKeyId);
        }

        private void indexKey(byte indexKey, int labelId, int propertyKeyId) {
            this.buffer.putByte(0, (byte)127).putInt(4, labelId).putInt(8, propertyKeyId).putByte(15, indexKey);
        }
    }

    private class DelegatingVisitor
    extends AbstractKeyValueStore.Visitor
    implements MetadataVisitor<Metadata> {
        private final CountsVisitor visitor;

        public DelegatingVisitor(CountsVisitor visitor) {
            super(CountsTracker.this);
            this.visitor = visitor;
        }

        protected boolean visitKeyValuePair(CountsKey key, ReadableBuffer value) {
            key.accept(this.visitor, value.getLong(0), value.getLong(8));
            return true;
        }

        @Override
        public void visitMetadata(File path, Metadata metadata, int entryCount) {
            if (this.visitor instanceof MetadataVisitor) {
                ((MetadataVisitor)((Object)this.visitor)).visitMetadata(path, metadata, entryCount);
            }
        }

        @Override
        protected boolean visitUnknownKey(UnknownKey exception, ReadableBuffer key, ReadableBuffer value) {
            if (this.visitor instanceof UnknownKey.Visitor) {
                return ((UnknownKey.Visitor)((Object)this.visitor)).visitUnknownKey(key, value);
            }
            return super.visitUnknownKey(exception, key, value);
        }
    }
}

