/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.api.CountsRecordState;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.state.NeoStoreProvider;

public class CountsComputer {
    private final NodeStore nodes;
    private final RelationshipStore relationships;

    public static CountsRecordState computeCounts(GraphDatabaseAPI api) {
        return CountsComputer.computeCounts((NeoStore)api.getDependencyResolver().resolveDependency(NeoStoreProvider.class).evaluate());
    }

    public static CountsRecordState computeCounts(NeoStore stores) {
        return CountsComputer.computeCounts(stores.getNodeStore(), stores.getRelationshipStore());
    }

    public static CountsRecordState computeCounts(NodeStore nodeStore, RelationshipStore relationshipStore) {
        CountsRecordState result = new CountsRecordState();
        new CountsComputer(nodeStore, relationshipStore).update(result);
        return result;
    }

    public CountsComputer(NodeStore nodes, RelationshipStore relationships) {
        this.nodes = nodes;
        this.relationships = relationships;
    }

    public void update(CountsRecordState target) {
        PrimitiveRecord record;
        long id;
        long highId = this.nodes.getHighId();
        for (id = 0L; id <= highId; ++id) {
            record = this.nodes.forceGetRecord(id);
            if (!record.inUse()) continue;
            target.addNode(this.labels((NodeRecord)record));
        }
        highId = this.relationships.getHighId();
        for (id = 0L; id <= highId; ++id) {
            record = this.relationships.forceGetRecord(id);
            if (!record.inUse()) continue;
            long[] startLabels = this.labels(this.nodes.forceGetRecord(((RelationshipRecord)record).getFirstNode()));
            long[] endLabels = this.labels(this.nodes.forceGetRecord(((RelationshipRecord)record).getSecondNode()));
            target.addRelationship(startLabels, ((RelationshipRecord)record).getType(), endLabels);
        }
    }

    private long[] labels(NodeRecord node) {
        return NodeLabelsField.get(node, this.nodes);
    }
}

