/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import java.io.File;
import java.io.IOException;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.SingleFilePageSwapperFactory;
import org.neo4j.io.pagecache.monitoring.PageCacheMonitor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.pagecache.LifecycledPageCache;
import org.neo4j.kernel.impl.pagecache.StandalonePageCache;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.lifecycle.LifeSupport;

public final class StandalonePageCacheFactory {
    private StandalonePageCacheFactory() {
    }

    public static StandalonePageCache createPageCache(FileSystemAbstraction fileSystem, String pageCacheName) {
        return StandalonePageCacheFactory.createPageCache(fileSystem, new Config(), pageCacheName);
    }

    public static StandalonePageCache createPageCache(FileSystemAbstraction fileSystem, Config config, String pageCacheName) {
        LifeSupport life = new LifeSupport();
        String qualifiedPageCacheName = "StandalonePageCache[" + pageCacheName + "]";
        Neo4jJobScheduler scheduler = life.add(new Neo4jJobScheduler(qualifiedPageCacheName));
        SingleFilePageSwapperFactory swapperFactory = new SingleFilePageSwapperFactory(fileSystem);
        Config baseConfig = new Config(MapUtil.stringMap(GraphDatabaseSettings.pagecache_memory.name(), "8M"));
        Config finalConfig = baseConfig.with(config.getParams());
        LifecycledPageCache delegate = life.add(new LifecycledPageCache((PageSwapperFactory)swapperFactory, scheduler, finalConfig, PageCacheMonitor.NULL));
        life.start();
        return new DelegatingStandalonePageCache(delegate, life, qualifiedPageCacheName);
    }

    private static final class DelegatingStandalonePageCache
    implements StandalonePageCache {
        private final LifecycledPageCache delegate;
        private final LifeSupport life;
        private final String pageCacheName;

        private DelegatingStandalonePageCache(LifecycledPageCache delegate, LifeSupport life, String pageCacheName) {
            this.delegate = delegate;
            this.life = life;
            this.pageCacheName = pageCacheName;
        }

        public PagedFile map(File file, int pageSize) throws IOException {
            return this.delegate.map(file, pageSize);
        }

        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() {
            this.life.shutdown();
        }

        public int pageSize() {
            return this.delegate.pageSize();
        }

        public int maxCachedPages() {
            return this.delegate.maxCachedPages();
        }

        public String toString() {
            return this.pageCacheName;
        }
    }
}

