/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.locking.community.LockNotFoundException;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.kernel.impl.locking.community.RagManager;
import org.neo4j.kernel.impl.transaction.IllegalResourceException;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class LockManagerImpl
implements LockManager {
    private final Map<Object, RWLock> resourceLockMap = new HashMap<Object, RWLock>();
    private final RagManager ragManager;

    public LockManagerImpl(RagManager ragManager) {
        this.ragManager = ragManager;
    }

    @Override
    public long getDetectedDeadlockCount() {
        return this.ragManager.getDeadlockCount();
    }

    @Override
    public void getReadLock(Object resource, Object tx) throws DeadlockDetectedException, IllegalResourceException {
        this.getRWLockForAcquiring(resource, tx).acquireReadLock(tx);
    }

    @Override
    public boolean tryReadLock(Object resource, Object tx) throws IllegalResourceException {
        return this.getRWLockForAcquiring(resource, tx).tryAcquireReadLock(tx);
    }

    @Override
    public void getWriteLock(Object resource, Object tx) throws DeadlockDetectedException, IllegalResourceException {
        this.getRWLockForAcquiring(resource, tx).acquireWriteLock(tx);
    }

    @Override
    public boolean tryWriteLock(Object resource, Object tx) throws IllegalResourceException {
        return this.getRWLockForAcquiring(resource, tx).tryAcquireWriteLock(tx);
    }

    @Override
    public void releaseReadLock(Object resource, Object tx) throws LockNotFoundException, IllegalResourceException {
        this.getRWLockForReleasing(resource, tx, 1, 0).releaseReadLock(tx);
    }

    @Override
    public void releaseWriteLock(Object resource, Object tx) throws LockNotFoundException, IllegalResourceException {
        this.getRWLockForReleasing(resource, tx, 0, 1).releaseWriteLock(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpLocksOnResource(Object resource, Logging logging) {
        RWLock lock;
        StringLogger logger = logging.getMessagesLog(LockManager.class);
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            if (!this.resourceLockMap.containsKey(resource)) {
                logger.info("No locks on " + resource);
                return;
            }
            lock = this.resourceLockMap.get(resource);
        }
        logger.logLongMessage("Dump locks on resource " + resource, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(Visitor<RWLock, RuntimeException> visitor) {
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            for (RWLock lock : this.resourceLockMap.values()) {
                if (visitor.visit(lock)) break;
            }
        }
    }

    private void assertValidArguments(Object resource, Object tx) {
        if (resource == null || tx == null) {
            throw new IllegalResourceException("Null parameter");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RWLock getRWLockForAcquiring(Object resource, Object tx) {
        this.assertValidArguments(resource, tx);
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            RWLock lock = this.resourceLockMap.get(resource);
            if (lock == null) {
                lock = new RWLock(resource, this.ragManager);
                this.resourceLockMap.put(resource, lock);
            }
            lock.mark();
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RWLock getRWLockForReleasing(Object resource, Object tx, int readCountPrerequisite, int writeCountPrerequisite) {
        this.assertValidArguments(resource, tx);
        Map<Object, RWLock> map = this.resourceLockMap;
        synchronized (map) {
            RWLock lock = this.resourceLockMap.get(resource);
            if (lock == null) {
                throw new LockNotFoundException("Lock not found for: " + resource + " tx:" + tx);
            }
            if (!lock.isMarked() && lock.getReadCount() == readCountPrerequisite && lock.getWriteCount() == writeCountPrerequisite && lock.getWaitingThreadsCount() == 0) {
                this.resourceLockMap.remove(resource);
            }
            return lock;
        }
    }
}

