/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.Iterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.ThisShouldNotHappenError;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.RelationshipVisitor;

public class RelationshipProxy
implements Relationship,
RelationshipVisitor<RuntimeException> {
    private final RelationshipActions actions;
    private short hiBits;
    private short type;
    private int loId;
    private int loSource;
    private int loTarget;

    public RelationshipProxy(RelationshipActions actions, long id, long startNode, int type, long endNode) {
        this.actions = actions;
        this.visit(id, type, startNode, endNode);
    }

    public RelationshipProxy(RelationshipActions actions, long id) {
        this.actions = actions;
        assert ((0xFFFFFFF000000000L & id) == 0L);
        this.hiBits = (short)(0xF000L | id >> 32);
        this.loId = (int)id;
    }

    @Override
    public void visit(long id, int type, long startNode, long endNode) throws RuntimeException {
        assert ((0xFFFFFFF000000000L & id) == 0L && (0xFFFFFFF000000000L & startNode) == 0L && (0xFFFFFFF000000000L & endNode) == 0L && (0xFFFF0000 & type) == 0);
        this.hiBits = (short)(id >> 32 | startNode >> 28 & 0xF0L | startNode >> 28 & 0xF00L);
        this.type = (short)type;
        this.loId = (int)id;
        this.loSource = (int)startNode;
        this.loTarget = (int)endNode;
    }

    private void initializeData() {
        if ((this.hiBits & 0xF000) != 0) {
            try (Statement statement = this.actions.statement();){
                statement.readOperations().relationshipVisit(this.getId(), this);
            }
            catch (EntityNotFoundException e) {
                throw new NotFoundException(e);
            }
        }
    }

    @Override
    public long getId() {
        return this.hiBits == 0 ? (long)this.loId : ((long)this.hiBits & 0xFL) << 32 | (long)this.loId;
    }

    private int typeId() {
        this.initializeData();
        return this.type & 0xFFFF;
    }

    private long sourceId() {
        this.initializeData();
        return this.hiBits == 0 ? (long)this.loSource : ((long)this.hiBits & 0xF0L) << 28 | (long)this.loSource;
    }

    private long targetId() {
        this.initializeData();
        return this.hiBits == 0 ? (long)this.loTarget : ((long)this.hiBits & 0xF00L) << 24 | (long)this.loTarget;
    }

    @Override
    public GraphDatabaseService getGraphDatabase() {
        return this.actions.getGraphDatabaseService();
    }

    @Override
    public void delete() {
        try (Statement statement = this.actions.statement();){
            statement.dataWriteOperations().relationshipDelete(this.getId());
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException("Unable to delete relationship[" + this.getId() + "] since it is already deleted.");
        }
    }

    @Override
    public Node[] getNodes() {
        this.assertInUnterminatedTransaction();
        return new Node[]{this.actions.newNodeProxy(this.sourceId()), this.actions.newNodeProxy(this.targetId())};
    }

    @Override
    public Node getOtherNode(Node node) {
        this.assertInUnterminatedTransaction();
        if (this.sourceId() == node.getId()) {
            return this.actions.newNodeProxy(this.targetId());
        }
        if (this.targetId() == node.getId()) {
            return this.actions.newNodeProxy(this.sourceId());
        }
        throw new NotFoundException("Node[" + node.getId() + "] not connected to this relationship[" + this.getId() + "]");
    }

    @Override
    public Node getStartNode() {
        this.assertInUnterminatedTransaction();
        return this.actions.newNodeProxy(this.sourceId());
    }

    @Override
    public Node getEndNode() {
        this.assertInUnterminatedTransaction();
        return this.actions.newNodeProxy(this.targetId());
    }

    @Override
    public RelationshipType getType() {
        this.assertInUnterminatedTransaction();
        return this.actions.getRelationshipTypeById(this.typeId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterable<String> getPropertyKeys() {
        try (Statement statement = this.actions.statement();){
            ArrayList<String> keys = new ArrayList<String>();
            Iterator<DefinedProperty> properties = statement.readOperations().relationshipGetAllProperties(this.getId());
            while (properties.hasNext()) {
                keys.add(statement.readOperations().propertyKeyGetName(properties.next().propertyKeyId()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (EntityNotFoundException e) {
            throw new NotFoundException("Relationship not found", e);
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new ThisShouldNotHappenError("Jake", "Property key retrieved through kernel API should exist.");
        }
    }

    @Override
    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        Throwable throwable = null;
        try (Statement statement = this.actions.statement();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyId == -1) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            Object object = statement.readOperations().relationshipGetProperty(this.getId(), propertyId).value();
            return object;
        }
        catch (EntityNotFoundException | PropertyNotFoundException e) {
            try {
                throw new NotFoundException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.actions.statement();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            Object object = statement.readOperations().relationshipGetProperty(this.getId(), propertyId).value(defaultValue);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (Statement statement = this.actions.statement();){
            int propertyId = statement.readOperations().propertyKeyGetForName(key);
            boolean bl = propertyId != -1 && statement.readOperations().relationshipGetProperty(this.getId(), propertyId).isDefined();
            return bl;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void setProperty(String key, Object value) {
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            statement.dataWriteOperations().relationshipSetProperty(this.getId(), Property.property(propertyKeyId, value));
        }
        catch (IllegalArgumentException e) {
            this.actions.failTransaction();
            throw e;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object removeProperty(String key) {
        try (Statement statement = this.actions.statement();){
            int propertyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            Object object = statement.dataWriteOperations().relationshipRemoveProperty(this.getId(), propertyId).value(null);
            return object;
        }
        catch (EntityNotFoundException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), e);
        }
    }

    @Override
    public boolean isType(RelationshipType type) {
        this.assertInUnterminatedTransaction();
        return this.actions.getRelationshipTypeById(this.typeId()).name().equals(type.name());
    }

    public int compareTo(Object rel) {
        long theirId;
        Relationship r = (Relationship)rel;
        long ourId = this.getId();
        if (ourId < (theirId = r.getId())) {
            return -1;
        }
        if (ourId > theirId) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        return o instanceof Relationship && this.getId() == ((Relationship)o).getId();
    }

    public int hashCode() {
        return (int)(this.getId() >>> 32 ^ this.getId());
    }

    public String toString() {
        return "Relationship[" + this.getId() + "]";
    }

    private void assertInUnterminatedTransaction() {
        this.actions.assertInUnterminatedTransaction();
    }

    public static interface RelationshipActions {
        public Statement statement();

        public Node newNodeProxy(long var1);

        public RelationshipType getRelationshipTypeById(int var1);

        public GraphDatabaseService getGraphDatabaseService();

        public void failTransaction();

        public void assertInUnterminatedTransaction();
    }
}

