/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.index.IndexImplementation;
import org.neo4j.kernel.impl.api.TransactionApplicationMode;
import org.neo4j.kernel.impl.index.IndexCommand;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexDefineCommand;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.util.IdOrderingQueue;

public class LegacyIndexApplier
extends NeoCommandHandler.Adapter {
    private final ProviderLookup providerLookup;
    private final Map<String, NeoCommandHandler> providerAppliers = new HashMap<String, NeoCommandHandler>();
    private final IndexConfigStore indexConfigStore;
    private final IdOrderingQueue transactionOrdering;
    private final long transactionId;
    private final TransactionApplicationMode mode;
    private IndexDefineCommand defineCommand;

    public LegacyIndexApplier(IndexConfigStore indexConfigStore, ProviderLookup providerLookup, IdOrderingQueue transactionOrdering, long transactionId, TransactionApplicationMode mode) {
        this.indexConfigStore = indexConfigStore;
        this.providerLookup = providerLookup;
        this.transactionOrdering = transactionOrdering;
        this.transactionId = transactionId;
        this.mode = mode;
    }

    private NeoCommandHandler applier(IndexCommand command) throws IOException {
        byte nameId = command.getIndexNameId();
        String indexName = this.defineCommand.getIndexName(nameId);
        NeoCommandHandler applier = this.providerAppliers.get(indexName);
        if (applier == null) {
            IndexEntityType entityType = IndexEntityType.byId(command.getEntityType());
            Map<String, String> config = this.indexConfigStore.get(entityType.entityClass(), indexName);
            if (config == null) {
                return NeoCommandHandler.EMPTY;
            }
            String providerName = config.get("provider");
            applier = this.providerLookup.lookup(providerName).newApplier(this.mode.needsIdempotencyChecks());
            applier.visitIndexDefineCommand(this.defineCommand);
            this.providerAppliers.put(indexName, applier);
        }
        return applier;
    }

    @Override
    public boolean visitIndexAddNodeCommand(IndexCommand.AddNodeCommand command) throws IOException {
        return this.applier(command).visitIndexAddNodeCommand(command);
    }

    @Override
    public boolean visitIndexAddRelationshipCommand(IndexCommand.AddRelationshipCommand command) throws IOException {
        return this.applier(command).visitIndexAddRelationshipCommand(command);
    }

    @Override
    public boolean visitIndexRemoveCommand(IndexCommand.RemoveCommand command) throws IOException {
        return this.applier(command).visitIndexRemoveCommand(command);
    }

    @Override
    public boolean visitIndexDeleteCommand(IndexCommand.DeleteCommand command) throws IOException {
        return this.applier(command).visitIndexDeleteCommand(command);
    }

    @Override
    public boolean visitIndexCreateCommand(IndexCommand.CreateCommand command) throws IOException {
        this.indexConfigStore.setIfNecessary(IndexEntityType.byId(command.getEntityType()).entityClass(), this.defineCommand.getIndexName(command.getIndexNameId()), command.getConfig());
        return this.applier(command).visitIndexCreateCommand(command);
    }

    @Override
    public boolean visitIndexDefineCommand(IndexDefineCommand command) throws IOException {
        this.defineCommand = command;
        return false;
    }

    @Override
    public void apply() {
        for (NeoCommandHandler applier : this.providerAppliers.values()) {
            applier.apply();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            for (NeoCommandHandler applier : this.providerAppliers.values()) {
                applier.close();
            }
        }
        finally {
            if (this.containsLegacyIndexCommands()) {
                this.notifyLegacyIndexOperationQueue();
            }
        }
    }

    private boolean containsLegacyIndexCommands() {
        return this.defineCommand != null;
    }

    private void notifyLegacyIndexOperationQueue() {
        this.transactionOrdering.removeChecked(this.transactionId);
    }

    public static interface ProviderLookup {
        public IndexImplementation lookup(String var1);

        public Iterable<IndexImplementation> providers();
    }
}

