/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.command.NeoCommandHandler;
import org.neo4j.kernel.impl.util.statistics.IntCounter;

public class CountsStoreApplier
extends NeoCommandHandler.Adapter {
    private final CountsAccessor.Updater countsUpdater;
    private final NodeStore nodeStore;
    private final Map<Integer, IntCounter> labelDelta = new HashMap<Integer, IntCounter>();
    private final Map<Integer, IntCounter> relationshipTypeDelta = new HashMap<Integer, IntCounter>();
    private int nodesDelta;
    private int relsDelta;

    public CountsStoreApplier(CountsAccessor.Updater countsUpdater, NodeStore nodeStore) {
        this.countsUpdater = countsUpdater;
        this.nodeStore = nodeStore;
    }

    @Override
    public void close() {
        this.countsUpdater.close();
    }

    private static <KEY> IntCounter counter(Map<KEY, IntCounter> map, KEY key) {
        IntCounter counter = map.get(key);
        if (counter == null) {
            counter = new IntCounter();
            map.put(key, counter);
        }
        return counter;
    }

    private static PrimitiveLongIterator diff(long[] remove, long[] add) {
        if (add == null || add.length == 0) {
            return PrimitiveLongCollections.emptyIterator();
        }
        if (remove == null || remove.length == 0) {
            return Primitive.iterator((long[])add);
        }
        return CountsStoreApplier.removeAll(CountsStoreApplier.addAll(Primitive.longSet((int)add.length), add), remove).iterator();
    }

    private static PrimitiveLongSet addAll(PrimitiveLongSet target, long ... all) {
        for (long label : all) {
            target.add(label);
        }
        return target;
    }

    private static PrimitiveLongSet removeAll(PrimitiveLongSet target, long ... all) {
        for (long label : all) {
            target.remove(label);
        }
        return target;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
        NodeRecord before = command.getBefore();
        NodeRecord after = command.getAfter();
        if (!before.inUse() && after.inUse()) {
            ++this.nodesDelta;
        } else if (before.inUse() && !after.inUse()) {
            --this.nodesDelta;
        }
        if (before.getLabelField() != after.getLabelField() || NodeLabelsField.fieldPointsToDynamicRecordOfLabels(before.getLabelField())) {
            long[] labelsBefore = this.labels(before);
            long[] labelsAfter = this.labels(after);
            PrimitiveLongIterator added = CountsStoreApplier.diff(labelsBefore, labelsAfter);
            while (added.hasNext()) {
                this.label(added.next()).increment();
            }
            PrimitiveLongIterator removed = CountsStoreApplier.diff(labelsAfter, labelsBefore);
            while (removed.hasNext()) {
                this.label(removed.next()).decrement();
            }
        }
        return false;
    }

    private IntCounter label(Number label) {
        return CountsStoreApplier.counter(this.labelDelta, label.intValue());
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
        RelationshipRecord record = command.getRecord();
        if (record.isCreated()) {
            ++this.relsDelta;
            this.relationshipType(record.getType()).increment();
        } else if (!record.inUse()) {
            --this.relsDelta;
            this.relationshipType(record.getType()).decrement();
        }
        return false;
    }

    @Override
    public boolean visitUpdateCountsCommand(Command.CountsCommand command) throws IOException {
        this.countsUpdater.incrementRelationshipCount(command.startLabelId(), command.typeId(), command.endLabelId(), command.delta());
        return false;
    }

    private IntCounter relationshipType(int type) {
        return CountsStoreApplier.counter(this.relationshipTypeDelta, type);
    }

    @Override
    public void apply() {
        this.countsUpdater.incrementNodeCount(-1, this.nodesDelta);
        for (Map.Entry<Integer, IntCounter> label : this.labelDelta.entrySet()) {
            this.countsUpdater.incrementNodeCount(label.getKey(), label.getValue().value());
        }
        this.countsUpdater.incrementRelationshipCount(-1, -1, -1, this.relsDelta);
        for (Map.Entry<Integer, IntCounter> type : this.relationshipTypeDelta.entrySet()) {
            this.countsUpdater.incrementRelationshipCount(-1, type.getKey(), -1, type.getValue().value());
        }
    }

    private long[] labels(NodeRecord node) {
        return node.inUse() ? NodeLabelsField.parseLabelsField(node).get(this.nodeStore) : null;
    }
}

