/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.neo4j.kernel.impl.api.CountsVisitor;
import org.neo4j.register.Register;

public interface CountsAccessor
extends CountsVisitor.Visitable {
    public Register.DoubleLongRegister nodeCount(int var1, Register.DoubleLongRegister var2);

    public Register.DoubleLongRegister relationshipCount(int var1, int var2, int var3, Register.DoubleLongRegister var4);

    public Register.DoubleLongRegister indexUpdatesAndSize(int var1, int var2, Register.DoubleLongRegister var3);

    public Register.DoubleLongRegister indexSample(int var1, int var2, Register.DoubleLongRegister var3);

    public void incrementIndexUpdates(int var1, int var2, long var3);

    public Updater updater();

    public static final class Initializer
    implements CountsVisitor {
        private final Updater target;

        public Initializer(Updater target) {
            this.target = target;
        }

        @Override
        public void visitNodeCount(int labelId, long count) {
            this.target.incrementNodeCount(labelId, count);
        }

        @Override
        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
            this.target.incrementRelationshipCount(startLabelId, typeId, endLabelId, count);
        }

        @Override
        public void visitIndexStatistics(int labelId, int propertyKeyId, long updates, long size) {
            this.target.replaceIndexUpdateAndSize(labelId, propertyKeyId, updates, size);
        }

        @Override
        public void visitIndexSample(int labelId, int propertyKeyId, long unique, long size) {
            this.target.replaceIndexSample(labelId, propertyKeyId, unique, size);
        }
    }

    public static interface Updater
    extends AutoCloseable {
        public void incrementNodeCount(int var1, long var2);

        public void incrementRelationshipCount(int var1, int var2, int var3, long var4);

        public void replaceIndexUpdateAndSize(int var1, int var2, long var3, long var5);

        public void replaceIndexSample(int var1, int var2, long var3, long var5);

        @Override
        public void close();
    }
}

