/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.neo4j.kernel.api.index.IndexEntryConflictException;

public class DuplicateIndexEntryConflictException
extends IndexEntryConflictException {
    private final Object propertyValue;
    private final Set<Long> conflictingNodeIds;

    public DuplicateIndexEntryConflictException(Object propertyValue, Set<Long> conflictingNodeIds) {
        super(String.format("Multiple nodes have property value %s:%n  %s", DuplicateIndexEntryConflictException.quote(propertyValue), DuplicateIndexEntryConflictException.asNodeList(conflictingNodeIds)));
        this.propertyValue = propertyValue;
        this.conflictingNodeIds = conflictingNodeIds;
    }

    @Override
    public Object getPropertyValue() {
        return this.propertyValue;
    }

    @Override
    public String evidenceMessage(String labelName, String propertyKey) {
        return String.format("Multiple nodes with label `%s` have property `%s` = %s:%n  %s", labelName, propertyKey, DuplicateIndexEntryConflictException.quote(this.propertyValue), DuplicateIndexEntryConflictException.asNodeList(this.conflictingNodeIds));
    }

    public Set<Long> getConflictingNodeIds() {
        return this.conflictingNodeIds;
    }

    private static String asNodeList(Collection<Long> nodeIds) {
        TreeSet<Long> ids = new TreeSet<Long>(nodeIds);
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (long nodeId : ids) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append("node(").append(nodeId).append(")");
        }
        return builder.toString();
    }
}

