/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;

public class KernelHealth {
    private static final String panicMessage = "Kernel has encountered some problem, please perform neccesary action (tx recovery/restart)";
    private volatile boolean tmOk = true;
    private final KernelPanicEventGenerator kpe;
    private final StringLogger log;
    private Throwable causeOfPanic;

    public KernelHealth(KernelPanicEventGenerator kpe, Logging logging) {
        this.kpe = kpe;
        this.log = logging.getMessagesLog(this.getClass());
    }

    public <EXCEPTION extends Throwable> void assertHealthy(Class<EXCEPTION> panicDisguise) throws EXCEPTION {
        if (!this.tmOk) {
            Throwable exception = null;
            try {
                try {
                    exception = (Throwable)panicDisguise.getConstructor(String.class, Throwable.class).newInstance(panicMessage, this.causeOfPanic);
                }
                catch (NoSuchMethodException e) {
                    exception = Exceptions.withCause((Throwable)panicDisguise.getConstructor(String.class).newInstance(panicMessage), this.causeOfPanic);
                }
            }
            catch (Exception e) {
                throw new Error("Kernel has encountered some problem, please perform neccesary action (tx recovery/restart). An exception of type " + panicDisguise.getName() + " was requested to be thrown but that proved imposslble", e);
            }
            throw exception;
        }
    }

    public void panic(Throwable cause) {
        if (!this.tmOk) {
            return;
        }
        if (cause == null) {
            throw new IllegalArgumentException("Must provide a cause for the kernel panic");
        }
        this.causeOfPanic = cause;
        this.tmOk = false;
        this.log.error("setting TM not OK. Kernel has encountered some problem, please perform neccesary action (tx recovery/restart)", cause);
        this.kpe.generateEvent(ErrorState.TX_MANAGER_NOT_OK, this.causeOfPanic);
    }

    public void healed() {
        this.tmOk = true;
        this.causeOfPanic = null;
        this.log.info("Kernel health set to OK");
    }
}

