/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.query.QueryEngineProvider;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;

public class GraphDatabaseDependencies
implements InternalAbstractGraphDatabase.Dependencies {
    private Monitors monitors;
    private final Logging logging;
    private final List<Class<?>> settingsClasses;
    private final List<KernelExtensionFactory<?>> kernelExtensions;
    private final List<CacheProvider> cacheProviders;
    private final List<QueryEngineProvider> queryEngineProviders;

    public static GraphDatabaseDependencies newDependencies() {
        ArrayList kernelExtensions = new ArrayList();
        for (KernelExtensionFactory factory : Service.load(KernelExtensionFactory.class)) {
            kernelExtensions.add(factory);
        }
        return new GraphDatabaseDependencies(null, null, new ArrayList(), kernelExtensions, Iterables.toList(Service.load(CacheProvider.class)), Iterables.toList(Service.load(QueryEngineProvider.class)));
    }

    private GraphDatabaseDependencies(Monitors monitors, Logging logging, List<Class<?>> settingsClasses, List<KernelExtensionFactory<?>> kernelExtensions, List<CacheProvider> cacheProviders, List<QueryEngineProvider> queryEngineProviders) {
        this.monitors = monitors;
        this.logging = logging;
        this.settingsClasses = settingsClasses;
        this.kernelExtensions = kernelExtensions;
        this.cacheProviders = cacheProviders;
        this.queryEngineProviders = queryEngineProviders;
    }

    public GraphDatabaseDependencies monitors(Monitors monitors) {
        return new GraphDatabaseDependencies(monitors, this.logging, this.settingsClasses, this.kernelExtensions, this.cacheProviders, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies logging(Logging logging) {
        return new GraphDatabaseDependencies(this.monitors, logging, this.settingsClasses, this.kernelExtensions, this.cacheProviders, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies settingsClasses(List<Class<?>> settingsClasses) {
        return new GraphDatabaseDependencies(this.monitors, this.logging, settingsClasses, this.kernelExtensions, this.cacheProviders, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies settingsClasses(Class<?> ... settingsClass) {
        this.settingsClasses.addAll(Arrays.asList(settingsClass));
        return new GraphDatabaseDependencies(this.monitors, this.logging, this.settingsClasses, this.kernelExtensions, this.cacheProviders, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies kernelExtensions(Iterable<KernelExtensionFactory<?>> kernelExtensions) {
        return new GraphDatabaseDependencies(this.monitors, this.logging, this.settingsClasses, Iterables.addAll(new ArrayList(), kernelExtensions), this.cacheProviders, this.queryEngineProviders);
    }

    public GraphDatabaseDependencies cacheProviders(Iterable<CacheProvider> cacheProviders) {
        return new GraphDatabaseDependencies(this.monitors, this.logging, this.settingsClasses, this.kernelExtensions, Iterables.addAll(this.cacheProviders, cacheProviders), this.queryEngineProviders);
    }

    public GraphDatabaseDependencies queryEngineProviders(Iterable<QueryEngineProvider> queryEngineProviders) {
        return new GraphDatabaseDependencies(this.monitors, this.logging, this.settingsClasses, this.kernelExtensions, this.cacheProviders, Iterables.addAll(this.queryEngineProviders, queryEngineProviders));
    }

    @Override
    public Monitors monitors() {
        return this.monitors;
    }

    @Override
    public Logging logging() {
        return this.logging;
    }

    @Override
    public Iterable<Class<?>> settingsClasses() {
        return this.settingsClasses;
    }

    @Override
    public Iterable<KernelExtensionFactory<?>> kernelExtensions() {
        return this.kernelExtensions;
    }

    @Override
    public Iterable<CacheProvider> cacheProviders() {
        return this.cacheProviders;
    }

    @Override
    public Iterable<QueryEngineProvider> executionEngines() {
        return this.queryEngineProviders;
    }
}

