/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.Arrays;
import org.neo4j.helpers.Function;

public final class Strings {
    public static final Function<String, String> decamelize = new Function<String, String>(){

        public String apply(String name) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (Character.isUpperCase(c)) {
                    if (i > 0) {
                        result.append('_');
                    }
                    result.append(Character.toLowerCase(c));
                    continue;
                }
                result.append(c);
            }
            return result.toString();
        }
    };

    private Strings() {
    }

    public static boolean isBlank(String str) {
        if (str == null || str.isEmpty()) {
            return true;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String defaultIfBlank(String str, String defaultStr) {
        return Strings.isBlank(str) ? defaultStr : str;
    }

    public static String prettyPrint(Object o) {
        if (o == null) {
            return "null";
        }
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            if (clazz == byte[].class) {
                return Arrays.toString((byte[])o);
            }
            if (clazz == short[].class) {
                return Arrays.toString((short[])o);
            }
            if (clazz == int[].class) {
                return Arrays.toString((int[])o);
            }
            if (clazz == long[].class) {
                return Arrays.toString((long[])o);
            }
            if (clazz == float[].class) {
                return Arrays.toString((float[])o);
            }
            if (clazz == double[].class) {
                return Arrays.toString((double[])o);
            }
            if (clazz == char[].class) {
                return Arrays.toString((char[])o);
            }
            if (clazz == boolean[].class) {
                return Arrays.toString((boolean[])o);
            }
            return Arrays.deepToString((Object[])o);
        }
        return String.valueOf(o);
    }
}

