/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store.io;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.helpers.Format;
import org.neo4j.unsafe.impl.batchimport.stats.DetailLevel;
import org.neo4j.unsafe.impl.batchimport.stats.GenericStatsProvider;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.Stat;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;

public class IoMonitor
extends GenericStatsProvider
implements Monitor {
    private volatile long startTime = System.currentTimeMillis();
    private volatile long endTime;
    private final AtomicLong totalWritten = new AtomicLong();

    public IoMonitor() {
        this.add(Keys.write_throughput, new Stat(){

            public String toString() {
                long stat = this.asLong();
                return stat == -1L ? "??" : Format.bytes(stat) + "/s";
            }

            @Override
            public long asLong() {
                long thisEndTime = IoMonitor.this.endTime != 0L ? IoMonitor.this.endTime : System.currentTimeMillis();
                long totalTime = thisEndTime - IoMonitor.this.startTime;
                int seconds = (int)(totalTime / 1000L);
                return seconds > 0 ? IoMonitor.this.totalWritten.get() / (long)seconds : -1L;
            }

            @Override
            public DetailLevel detailLevel() {
                return DetailLevel.IMPORTANT;
            }
        });
    }

    @Override
    public void dataWritten(int bytes) {
        this.totalWritten.addAndGet(bytes);
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
        this.totalWritten.set(0L);
    }

    public void stop() {
        this.endTime = System.currentTimeMillis();
    }

    public long startTime() {
        return this.startTime;
    }

    public long totalBytesWritten() {
        return this.totalWritten.get();
    }
}

