/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.util.Arrays;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.function.Function;
import org.neo4j.unsafe.impl.batchimport.input.Group;
import org.neo4j.unsafe.impl.batchimport.input.Groups;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.InputEntityDeserializer;
import org.neo4j.unsafe.impl.batchimport.input.csv.Type;

class InputNodeDeserializer
extends InputEntityDeserializer<InputNode> {
    private final boolean idsAreExternal;
    private Object id;
    private String[] labels = new String[10];
    private int labelsCursor;
    private final Group group;

    InputNodeDeserializer(Header header, CharSeeker data, int[] delimiter, Function<InputNode, InputNode> decorator, boolean idsAreExternal, Groups groups) {
        super(header, data, delimiter, decorator);
        this.idsAreExternal = idsAreExternal;
        Header.Entry idEntry = header.entry(Type.ID);
        this.group = idEntry != null ? groups.getOrCreate(idEntry.groupName()) : Group.GLOBAL;
    }

    @Override
    protected void handleValue(Header.Entry entry, Object value) {
        switch (entry.type()) {
            case ID: {
                if (entry.name() != null && this.idsAreExternal) {
                    this.addProperty(entry, value);
                }
                this.id = value;
                break;
            }
            case LABEL: {
                if (value instanceof String) {
                    this.ensureLabelsCapacity(this.labelsCursor + 1);
                    this.labels[this.labelsCursor++] = (String)value;
                    break;
                }
                if (value instanceof String[]) {
                    String[] labelsToAdd = (String[])value;
                    this.ensureLabelsCapacity(this.labelsCursor + labelsToAdd.length);
                    for (String label : (String[])value) {
                        this.labels[this.labelsCursor++] = label;
                    }
                    break;
                }
                throw new IllegalArgumentException("Unexpected label value type " + value.getClass() + ": " + value);
            }
        }
    }

    private void ensureLabelsCapacity(int length) {
        if (length > this.labels.length) {
            this.labels = Arrays.copyOf(this.labels, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected InputNode convertToInputEntity(Object[] properties) {
        try {
            InputNode inputNode = new InputNode(this.group, this.id, properties, null, this.labels(), null);
            return inputNode;
        }
        finally {
            this.id = null;
            this.labelsCursor = 0;
        }
    }

    private String[] labels() {
        return this.labelsCursor > 0 ? Arrays.copyOf(this.labels, this.labelsCursor) : InputEntity.NO_LABELS;
    }
}

