/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input.csv;

import java.util.Iterator;
import org.neo4j.csv.reader.CharSeeker;
import org.neo4j.function.Function;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.NestingIterator;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.csv.Configuration;
import org.neo4j.unsafe.impl.batchimport.input.csv.Data;
import org.neo4j.unsafe.impl.batchimport.input.csv.DataFactory;
import org.neo4j.unsafe.impl.batchimport.input.csv.Header;
import org.neo4j.unsafe.impl.batchimport.input.csv.IdType;

abstract class InputGroupsDeserializer<ENTITY extends InputEntity>
extends NestingIterator<ENTITY, DataFactory<ENTITY>>
implements ResourceIterator<ENTITY> {
    private final Header.Factory headerFactory;
    private final Configuration config;
    private final IdType idType;
    private ResourceIterator<ENTITY> currentInput;

    InputGroupsDeserializer(Iterator<DataFactory<ENTITY>> dataFactory, Header.Factory headerFactory, Configuration config, IdType idType) {
        super(dataFactory);
        this.headerFactory = headerFactory;
        this.config = config;
        this.idType = idType;
    }

    @Override
    protected ResourceIterator<ENTITY> createNestedIterator(DataFactory<ENTITY> dataFactory) {
        this.closeCurrent();
        Data<ENTITY> data = dataFactory.create(this.config);
        CharSeeker dataStream = data.stream();
        Header dataHeader = this.headerFactory.create(dataStream, this.config, this.idType);
        this.currentInput = this.entityDeserializer(dataStream, dataHeader, data.decorator());
        return this.currentInput;
    }

    private void closeCurrent() {
        if (this.currentInput != null) {
            this.currentInput.close();
        }
    }

    protected abstract ResourceIterator<ENTITY> entityDeserializer(CharSeeker var1, Header var2, Function<ENTITY, ENTITY> var3);

    @Override
    public void close() {
        this.closeCurrent();
    }
}

