/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.unsafe.impl.batchimport.input.Group;

public class Groups {
    private final Map<String, Group> groups = new HashMap<String, Group>();
    private int nextId = 0;
    private Boolean globalMode;

    public Group getOrCreate(String name) {
        boolean global;
        boolean bl = global = name == null;
        if (this.globalMode == null) {
            this.globalMode = global;
        } else if (global != this.globalMode) {
            throw new IllegalStateException("Mixing specified and unspecified group belongings in a single import isn't supported");
        }
        if (global) {
            return Group.GLOBAL;
        }
        Group group = this.groups.get(name);
        if (group == null) {
            group = new Group.Adapter(this.nextId++, name);
            this.groups.put(name, group);
        }
        return group;
    }

    public Group get(String name) {
        if (name == null) {
            return Group.GLOBAL;
        }
        Group group = this.groups.get(name);
        if (group == null) {
            throw new IllegalArgumentException("Unknown group '" + name + "'");
        }
        return group;
    }
}

