/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArray;

abstract class HeapNumberArray
implements NumberArray {
    private final int itemSize;
    protected long highestSetIndex;
    protected long size;

    protected HeapNumberArray(int itemSize) {
        this.itemSize = itemSize;
    }

    @Override
    public long highestSetIndex() {
        return this.highestSetIndex;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.highestSetIndex = -1L;
        this.size = 0L;
    }

    @Override
    public void visit(MemoryStatsVisitor visitor) {
        visitor.heapUsage(this.length() * (long)this.itemSize);
    }

    @Override
    public void close() {
    }
}

