/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;

public interface AvailableMemoryCalculator {
    public static final AvailableMemoryCalculator RUNTIME = new AvailableMemoryCalculator(){

        @Override
        public long availableOffHeapMemory() {
            OperatingSystemMXBean bean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            long osMemory = bean.getTotalPhysicalMemorySize();
            return osMemory - Runtime.getRuntime().maxMemory();
        }

        @Override
        public long availableHeapMemory() {
            System.gc();
            Runtime runtime = Runtime.getRuntime();
            return runtime.maxMemory() - runtime.totalMemory();
        }

        public String toString() {
            return "Java runtime memory calculator";
        }
    };

    public long availableHeapMemory();

    public long availableOffHeapMemory();
}

