/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

public interface StoreProcessor<T> {
    public boolean process(T var1);

    public void done();

    public static class Multiple<T>
    implements StoreProcessor<T> {
        private final StoreProcessor<T>[] processors;

        @SafeVarargs
        public Multiple(StoreProcessor<T> ... processors) {
            this.processors = processors;
        }

        @Override
        public boolean process(T item) {
            boolean result = false;
            for (StoreProcessor<T> processor : this.processors) {
                result |= processor.process(item);
            }
            return result;
        }

        @Override
        public void done() {
            for (StoreProcessor<T> processor : this.processors) {
                processor.done();
            }
        }
    }
}

