/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.StoreProcessor;
import org.neo4j.unsafe.impl.batchimport.staging.LonelyProcessingStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class RelationshipStoreProcessorStep
extends LonelyProcessingStep {
    private final RelationshipStore relationshipStore;
    private final StoreProcessor<RelationshipRecord> processor;

    protected RelationshipStoreProcessorStep(StageControl control, String name, Configuration config, RelationshipStore relationshipStore, StoreProcessor<RelationshipRecord> processor) {
        super(control, name, config.batchSize(), config.movingAverageSize());
        this.relationshipStore = relationshipStore;
        this.processor = processor;
    }

    @Override
    protected final void process() {
        long highId = this.relationshipStore.getHighestPossibleIdInUse();
        RelationshipRecord heavilyReusedRecord = new RelationshipRecord(-1L);
        for (long i = highId; i >= 0L; --i) {
            if (this.relationshipStore.fillRecord(i, heavilyReusedRecord, RecordLoad.CHECK) && this.processor.process(heavilyReusedRecord)) {
                this.relationshipStore.updateRecord(heavilyReusedRecord);
            }
            this.itemProcessed();
        }
        this.processor.done();
    }
}

