/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.List;
import org.neo4j.helpers.Pair;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutorServiceStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;

public class RelationshipPreparationStep
extends ExecutorServiceStep<List<InputRelationship>> {
    private final IdMapper idMapper;

    public RelationshipPreparationStep(StageControl control, Configuration config, IdMapper idMapper) {
        super(control, "PREPARE", config.workAheadSize(), config.movingAverageSize(), 1, true);
        this.idMapper = idMapper;
    }

    @Override
    protected Object process(long ticket, List<InputRelationship> batch) {
        long[] ids = new long[batch.size() * 2];
        int index = 0;
        for (InputRelationship batchRelationship : batch) {
            ids[index++] = this.idMapper.get(batchRelationship.startNode(), batchRelationship.startNodeGroup());
            ids[index++] = this.idMapper.get(batchRelationship.endNode(), batchRelationship.endNodeGroup());
        }
        return Pair.of(batch, ids);
    }
}

