/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.neo4j.function.Function;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogFilenames;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.CommandWriter;
import org.neo4j.kernel.impl.transaction.log.IOCursor;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.PhysicalWritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.WritableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommand;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriterv1;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeaderWriter;

class LegacyLogEntryWriter {
    private static final Function<WritableLogChannel, LogEntryWriter> defaultLogEntryWriterFactory = new Function<WritableLogChannel, LogEntryWriter>(){

        public LogEntryWriter apply(WritableLogChannel channel) {
            return new LogEntryWriterv1(channel, new CommandWriter(channel));
        }
    };
    private final FileSystemAbstraction fs;
    private final Function<WritableLogChannel, LogEntryWriter> factory;

    LegacyLogEntryWriter(FileSystemAbstraction fs) {
        this(fs, defaultLogEntryWriterFactory);
    }

    LegacyLogEntryWriter(FileSystemAbstraction fs, Function<WritableLogChannel, LogEntryWriter> factory) {
        this.fs = fs;
        this.factory = factory;
    }

    public LogVersionedStoreChannel openWritableChannel(File file) throws IOException {
        StoreChannel storeChannel = this.fs.open(file, "rw");
        long version = LegacyLogFilenames.getLegacyLogVersion(file.getName());
        return new PhysicalLogVersionedStoreChannel(storeChannel, version, 5);
    }

    public void writeLogHeader(LogVersionedStoreChannel channel, LogHeader header) throws IOException {
        LogHeaderWriter.writeLogHeader(channel, header.logVersion, header.lastCommittedTxId);
    }

    public void writeAllLogEntries(LogVersionedStoreChannel channel, IOCursor<LogEntry> cursor) throws IOException {
        try (PhysicalWritableLogChannel writable = new PhysicalWritableLogChannel(channel);){
            LogEntryWriter writer = (LogEntryWriter)this.factory.apply((Object)writable);
            ArrayList<Command> commands = new ArrayList<Command>();
            while (cursor.next()) {
                LogEntry entry = cursor.get();
                if (entry instanceof LogEntryStart) {
                    LogEntryStart startEntry = (LogEntryStart)entry.as();
                    writer.writeStartEntry(startEntry.getMasterId(), startEntry.getLocalId(), startEntry.getTimeWritten(), startEntry.getLastCommittedTxWhenTransactionStarted(), startEntry.getAdditionalHeader());
                    continue;
                }
                if (entry instanceof LogEntryCommit) {
                    if (!commands.isEmpty()) {
                        writer.serialize(new PhysicalTransactionRepresentation(commands));
                        commands = new ArrayList();
                    }
                    LogEntryCommit commitEntry = (LogEntryCommit)entry;
                    writer.writeCommitEntry(commitEntry.getTxId(), commitEntry.getTimeWritten());
                    continue;
                }
                if (entry instanceof LogEntryCommand) {
                    commands.add(((LogEntryCommand)entry).getXaCommand());
                    continue;
                }
                throw new IllegalStateException("Unknown entry: " + entry);
            }
        }
    }
}

