/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format.v2_2;

import java.util.Collections;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.impl.store.format.NeoStoreFormatUtils;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.standard.BaseRecordCursor;
import org.neo4j.kernel.impl.store.standard.FixedSizeRecordStoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreFormat;
import org.neo4j.kernel.impl.store.standard.StoreToolkit;

public class NodeStoreFormat_v2_2
extends FixedSizeRecordStoreFormat<NodeRecord, NodeRecordCursor> {
    private final NodeRecordFormat recordFormat = new NodeRecordFormat();

    public NodeStoreFormat_v2_2() {
        super(15, "NodeStore", "v0.A.4");
    }

    @Override
    public NodeRecordCursor createCursor(PagedFile file, StoreToolkit toolkit, int flags) {
        return new NodeRecordCursor(file, toolkit, this.recordFormat, flags);
    }

    @Override
    public StoreFormat.RecordFormat<NodeRecord> recordFormat() {
        return this.recordFormat;
    }

    public static class NodeRecordCursor
    extends BaseRecordCursor<NodeRecord, NodeRecordFormat> {
        public NodeRecordCursor(PagedFile file, StoreToolkit toolkit, NodeRecordFormat format, int flags) {
            super(file, toolkit, format, flags);
        }

        public long firstRelationship() {
            return ((NodeRecordFormat)this.format).firstRelationship(this.pageCursor, this.currentRecordOffset);
        }
    }

    public static class NodeRecordFormat
    implements StoreFormat.RecordFormat<NodeRecord> {
        private static final int IN_USE = 0;
        private static final int NEXT_REL_BASE = 1;
        private static final int NEXT_PROP_BASE = 5;
        private static final int LSB_LABELS = 9;
        private static final int MSB_LABELS = 13;
        private static final int EXTRA = 14;
        private static final int RECORD_SIZE = 15;

        @Override
        public String recordName() {
            return "NodeRecord";
        }

        @Override
        public long id(NodeRecord nodeRecord) {
            return nodeRecord.getId();
        }

        @Override
        public void serialize(PageCursor cursor, int offset, NodeRecord record) {
            if (record.inUse()) {
                long nextRel = record.getNextRel();
                long nextProp = record.getNextProp();
                short relModifier = nextRel == (long)Record.NO_NEXT_RELATIONSHIP.intValue() ? (short)0 : (short)((nextRel & 0x700000000L) >> 31);
                int propModifier = (short)(nextProp == (long)Record.NO_NEXT_PROPERTY.intValue() ? 0 : (short)((nextProp & 0xF00000000L) >> 28));
                short inUseUnsignedByte = (record.inUse() ? Record.IN_USE : Record.NOT_IN_USE).byteValue();
                inUseUnsignedByte = (short)(inUseUnsignedByte | relModifier | propModifier);
                cursor.putByte(offset + 0, (byte)inUseUnsignedByte);
                cursor.putInt(offset + 1, (int)nextRel);
                cursor.putInt(offset + 5, (int)nextProp);
                long labelField = record.getLabelField();
                cursor.putInt(offset + 9, (int)labelField);
                cursor.putByte(offset + 13, (byte)((labelField & 0xFF00000000L) >> 32));
                byte extra = record.isDense() ? (byte)1 : 0;
                cursor.putByte(offset + 14, extra);
            } else {
                cursor.putByte(offset + 0, (byte)0);
            }
        }

        @Override
        public NodeRecord deserialize(PageCursor cursor, int offset, long id) {
            NodeRecord record = new NodeRecord(id);
            byte inUseByte = cursor.getByte(offset + 0);
            long nextRel = cursor.getUnsignedInt(offset + 1);
            long nextProp = cursor.getUnsignedInt(offset + 5);
            long lsbLabels = cursor.getUnsignedInt(offset + 9);
            long hsbLabels = cursor.getByte(offset + 13) & 0xFF;
            byte extra = cursor.getByte(offset + 14);
            long relModifier = ((long)inUseByte & 0xEL) << 31;
            long propModifier = ((long)inUseByte & 0xF0L) << 28;
            long labels = lsbLabels | hsbLabels << 32;
            boolean dense = (extra & 1) > 0;
            record.setDense(dense);
            record.setNextRel(NeoStoreFormatUtils.longFromIntAndMod(nextRel, relModifier));
            record.setNextProp(NeoStoreFormatUtils.longFromIntAndMod(nextProp, propModifier));
            record.setInUse((inUseByte & 1) == 1);
            record.setLabelField(labels, Collections.emptyList());
            return record;
        }

        @Override
        public boolean inUse(PageCursor cursor, int offset) {
            return (cursor.getByte(offset + 0) & 1) == 1;
        }

        public long firstRelationship(PageCursor cursor, int offset) {
            return NeoStoreFormatUtils.longFromIntAndMod(cursor.getUnsignedInt(offset + 1), ((long)cursor.getByte(offset + 0) & 0xEL) << 31);
        }
    }
}

