/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.counts;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.counts.keys.CountsKey;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyFactory;
import org.neo4j.kernel.impl.store.counts.keys.CountsKeyType;
import org.neo4j.kernel.impl.store.kvstore.KeyValueRecordSerializer;
import org.neo4j.kernel.impl.store.kvstore.KeyValueRecordVisitor;
import org.neo4j.register.Register;

public final class CountsRecordSerializer
implements KeyValueRecordSerializer<CountsKey, Register.CopyableDoubleLongRegister> {
    public static final CountsRecordSerializer INSTANCE = new CountsRecordSerializer();
    public static final long DEFAULT_FIRST_VALUE = 0L;
    public static final long DEFAULT_SECOND_VALUE = 0L;

    private CountsRecordSerializer() {
    }

    @Override
    public boolean visitRecord(ByteBuffer buffer, KeyValueRecordVisitor<CountsKey, Register.CopyableDoubleLongRegister> visitor, Register.CopyableDoubleLongRegister valueRegister) {
        CountsKey key;
        byte type = buffer.get();
        buffer.get();
        int one = buffer.getInt();
        buffer.get();
        int two = buffer.getInt();
        buffer.get();
        int three = buffer.getInt();
        long first = buffer.getLong();
        long second = buffer.getLong();
        valueRegister.write(first, second);
        switch (CountsKeyType.fromCode(type)) {
            case EMPTY: {
                assert (one == 0);
                assert (two == 0);
                assert (three == 0);
                assert (first == 0L);
                assert (second == 0L);
                return false;
            }
            case ENTITY_NODE: {
                assert (one == 0);
                assert (two == 0);
                assert (first == 0L);
                key = CountsKeyFactory.nodeKey(three);
                break;
            }
            case ENTITY_RELATIONSHIP: {
                assert (first == 0L);
                key = CountsKeyFactory.relationshipKey(one, two, three);
                break;
            }
            case INDEX_COUNTS: {
                assert (one == 0);
                key = CountsKeyFactory.indexCountsKey(three, two);
                break;
            }
            case INDEX_SAMPLE: {
                assert (one == 0);
                key = CountsKeyFactory.indexSampleKey(three, two);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown counts key type: " + type);
            }
        }
        visitor.visit(key, valueRegister);
        return true;
    }

    @Override
    public CountsKey readRecord(PageCursor cursor, int offset, Register.CopyableDoubleLongRegister value) throws IOException {
        CountsKey key;
        long second;
        long first;
        int three;
        int two;
        int one;
        byte type;
        do {
            cursor.setOffset(offset);
            type = cursor.getByte();
            cursor.getByte();
            one = cursor.getInt();
            cursor.getByte();
            two = cursor.getInt();
            cursor.getByte();
            three = cursor.getInt();
            first = cursor.getLong();
            second = cursor.getLong();
        } while (cursor.shouldRetry());
        value.write(first, second);
        switch (CountsKeyType.fromCode(type)) {
            case EMPTY: {
                throw new IllegalStateException("Reading empty record");
            }
            case ENTITY_NODE: {
                assert (one == 0);
                assert (two == 0);
                key = CountsKeyFactory.nodeKey(three);
                break;
            }
            case ENTITY_RELATIONSHIP: {
                key = CountsKeyFactory.relationshipKey(one, two, three);
                break;
            }
            case INDEX_COUNTS: {
                assert (one == 0);
                key = CountsKeyFactory.indexCountsKey(three, two);
                break;
            }
            case INDEX_SAMPLE: {
                assert (one == 0);
                key = CountsKeyFactory.indexSampleKey(three, two);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown counts key type: " + type);
            }
        }
        return key;
    }

    @Override
    public void writeDefaultValue(Register.CopyableDoubleLongRegister valueRegister) {
        valueRegister.write(0L, 0L);
    }
}

